/* *##%
 * Copyright (c) 2010 poussin. All rights reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/
package org.nuiton.wikitty.ui;

import java.io.IOException;
import static org.nuiton.i18n.I18n._;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;

/**
 *
 * @author poussin
 * @version $Revision$
 *
 * Last update: $Date$
 * by : $Author$
 */
public class WikittyZkConfig extends ApplicationConfig {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(WikittyZkConfig.class);
    /** Singleton instance. */
    protected static WikittyZkConfig instance = null;

    public WikittyZkConfig() {
        super();

        // set default option (included configuration file name : important)
        for (Option o : Option.values()) {
            if (o.defaultValue != null) {
                setDefaultOption(o.key, o.defaultValue);
            }
        }
    }

    public static synchronized WikittyZkConfig getInstance() throws IOException {
        if (instance == null) {
            try {
                instance = new WikittyZkConfig();
                instance.parse(new String[]{});
                instance.setDataDirInSystemProps();
            } catch (Exception e) {
                throw new UnhandledException(e);
            }
        }
        Properties props = instance.getFlatOptions();
        Set<String> names = props.stringPropertyNames();
        for (String name : names) {
            System.out.println(name + "=" + props.getProperty(name));
        }
        File file = new File("/var/wikitty-zk/toto.fr");
        if (!file.exists()) {
            file.createNewFile();
        }
        OutputStream stream = new FileOutputStream(file);
        props.store(stream, null);
        stream.close();
        return instance;
    }

    /**
     * Get version as string.
     *
     * @return version
     */
    public String getVersion() {
        return getOption(Option.APPLICATION_VERSION.key);
    }

    /**
     * Get bow url as string.
     *
     * @return url
     */
    public String getBowUrl() {
        return getOption(Option.BOW_URL.key);
    }

    public File getDataDirAsFile() {
        File option = getOptionAsFile(Option.DATA_DIR.key);
        return option;
    }

    /**
     * Set {@code solr} and {@code jms} system configuration.
     *
     * This is the "only" way to configure embedded solr.
     */
    protected void setDataDirInSystemProps() {
        String value = System.getProperty(Option.DATA_DIR.key, null);
        if (value == null) {
            value = getOption(Option.DATA_DIR.key);
            if (log.isInfoEnabled()) {
                log.info("Setting system property " + Option.DATA_DIR.key + " : " + value);
            }
            System.setProperty(Option.DATA_DIR.key, value);
            env.put(Option.DATA_DIR.key, value);
            System.out.println(Option.DATA_DIR.key);
        }
    }

    /**
     * Vradi option definition.
     */
    public static enum Option {

        CONFIG_FILE(CONFIG_FILE_NAME, _("bow.config.configFileName.description"),
        "bow.properties", String.class, false, false),
        APPLICATION_VERSION("application.version", _("wikitty-ui-zk.config.application.version.description"),
        null, String.class, true, true),
        BOW_URL("bow.url", _("wikitty-ui-zk.config.bow.url.description"),
        null, String.class, false, false),
        DATA_DIR("solr.data.dir", _("wikitty-ui-zk.config.data.dir.description"),
        System.getProperty("user.home") + "/.bow/solr", String.class, false, false);
        public final String key;
        public final String description;
        public final String defaultValue;
        public final Class<?> type;
        public final boolean isTransient;
        public final boolean isFinal;

        private Option(String key, String description, String defaultValue,
                Class<?> type, boolean isTransient, boolean isFinal) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this.isFinal = isFinal;
            this.isTransient = isTransient;
        }
    }
}
