/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nuiton.wikitty.ui;

import java.util.ArrayList;
import java.util.List;
import org.nuiton.wikitty.Wikitty;
import org.zkoss.zkplus.databind.BindingListModel;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.event.ListDataEvent;

/**
 *
 * @author sherkhan
 */
public class WikittyModel extends AbstractListModel implements BindingListModel {

    List<Wikitty> _wikitties = new ArrayList<Wikitty>();

    @Override
    public Object getElementAt(int index) {
        return _wikitties.get(index);
    }

    @Override
    public int getSize() {
        return _wikitties.size();
    }

    @Override
    public int indexOf(Object obj) {
        return _wikitties.indexOf(obj);
    }

    public void setWikitties(List<Wikitty> wikitties) {
        _wikitties = new ArrayList<Wikitty>(wikitties);
        fireEvent(ListDataEvent.CONTENTS_CHANGED, -1, -1);
    }

    public void addData(Wikitty newData) {
        _wikitties.add(newData);
        fireEvent(ListDataEvent.INTERVAL_ADDED, _wikitties.size() - 1, _wikitties.size() - 1);
    }

    public void removeData(Wikitty data) {
        int interval = _wikitties.indexOf(data);
        _wikitties.remove(data);
        fireEvent(ListDataEvent.INTERVAL_REMOVED, interval, interval);
    }

    public void reload() {
        fireEvent(ListDataEvent.CONTENTS_CHANGED, -1, -1);
    }
}
