/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.storage.solr;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyTreeNodeHelper;
import org.nuiton.wikitty.entities.WikittyTypes;
import org.nuiton.wikitty.storage.solr.SolrUtil;

public class AttachmentInTree {
    private static Log log = LogFactory.getLog(AttachmentInTree.class);
    protected Set<String> allAttachmentToIndex = new HashSet<String>();
    protected Factory listFactory = new Factory(){

        public Object create() {
            return new HashSet();
        }
    };
    protected Map<String, Set<String>> attachmentRemovedInTree = LazyMap.decorate(new HashMap(), (Factory)this.listFactory);
    protected Map<String, Set<String>> attachmentAddedInTree = LazyMap.decorate(new HashMap(), (Factory)this.listFactory);

    public void clean(Collection<String> ids) {
        if (ids != null) {
            this.allAttachmentToIndex.removeAll(ids);
            for (Set<String> set : this.attachmentRemovedInTree.values()) {
                set.removeAll(ids);
            }
            for (Set<String> set : this.attachmentAddedInTree.values()) {
                set.removeAll(ids);
            }
        }
    }

    public int size() {
        return this.allAttachmentToIndex.size();
    }

    public Set<String> getAll() {
        return this.allAttachmentToIndex;
    }

    public Map<String, Set<String>> getAdded() {
        return this.attachmentAddedInTree;
    }

    public Map<String, Set<String>> getRemoved() {
        return this.attachmentRemovedInTree;
    }

    public void remove(String id, Collection<String> attId) {
        if (attId != null && !attId.isEmpty()) {
            this.attachmentRemovedInTree.get(id).addAll(attId);
            this.allAttachmentToIndex.addAll(attId);
        }
    }

    public void remove(SolrDocument doc) {
        String id = SolrUtil.getStringFieldValue(doc, "#id");
        Collection<String> att = SolrUtil.getStringFieldValues(doc, "WikittyTreeNode.attachment", WikittyTypes.WIKITTY);
        this.remove(id, att);
    }

    public void remove(SolrInputDocument doc) {
        String id = SolrUtil.getStringFieldValue(doc, "#id");
        Collection<String> att = SolrUtil.getStringFieldValues(doc, "WikittyTreeNode.attachment", WikittyTypes.WIKITTY);
        this.remove(id, att);
    }

    public void add(String id, Collection<String> attId) {
        if (attId != null && !attId.isEmpty()) {
            this.attachmentAddedInTree.get(id).addAll(attId);
            this.allAttachmentToIndex.addAll(attId);
        }
    }

    public void add(String id, String attId) {
        if (attId != null) {
            this.attachmentAddedInTree.get(id).add(attId);
            this.allAttachmentToIndex.add(attId);
        }
    }

    public void add(SolrDocument doc) {
        String id = SolrUtil.getStringFieldValue(doc, "#id");
        Collection<String> att = SolrUtil.getStringFieldValues(doc, "WikittyTreeNode.attachment", WikittyTypes.WIKITTY);
        this.add(id, att);
    }

    public void add(SolrDocument doc, Set<String> restriction) {
        String id = SolrUtil.getStringFieldValue(doc, "#id");
        Collection<String> att = SolrUtil.getStringFieldValues(doc, "WikittyTreeNode.attachment", WikittyTypes.WIKITTY);
        if (att != null) {
            for (String attId : att) {
                if (!restriction.contains(attId)) continue;
                this.add(id, attId);
            }
        }
    }

    public void add(SolrInputDocument doc) {
        String id = SolrUtil.getStringFieldValue(doc, "#id");
        Collection<String> att = SolrUtil.getStringFieldValues(doc, "WikittyTreeNode.attachment", WikittyTypes.WIKITTY);
        this.add(id, att);
    }

    public void add(Wikitty w) {
        String id = w.getId();
        Set att = WikittyTreeNodeHelper.getAttachment((Wikitty)w);
        this.add(id, att);
    }
}

