/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.dbcp.managed.BasicManagedDataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyException;

public class WikittyJDBCUtil {
    private static Log log = LogFactory.getLog(WikittyJDBCUtil.class);
    public static final String COL_EXTENSION = "extension_list";
    public static final String COL_VERSION = "version";
    public static final String COL_ID = "id";
    public static final String COL_NAME = "name";
    public static final String COL_REQUIRES = "requires";
    public static final String COL_TAGVALUES = "tagvalues";
    public static final String COL_FIELDNAME = "fieldName";
    public static final String COL_FIELDTYPE = "fieldType";
    public static final String COL_BOOLEAN_VALUE = "booleanValue";
    public static final String COL_NUMBER_VALUE = "numberValue";
    public static final String COL_TEXT_VALUE = "textValue";
    public static final String COL_DATE_VALUE = "dateValue";
    public static final String COL_DELETION_DATE = "deletionDate";
    public static final String QUERY_SELECT = "jdbc.queries.select";
    public static final String QUERY_SELECT_NOTDELETED = "jdbc.queries.select.notdeleted";
    public static final String QUERY_SELECT_WHERE = "jdbc.queries.select.where";
    public static final String QUERY_SELECT_TWO_WHERE = "jdbc.queries.select.two.where";
    public static final String QUERY_SELECT_WHERE_NOTDELETED = "jdbc.queries.select.where.notdeleted";
    public static final String QUERY_CREATION_WIKITTY_ADMIN_TEST = "jdbc.queries.creation.wikitty.admin.test";
    public static final String QUERY_CREATION_WIKITTY_ADMIN = "jdbc.queries.creation.wikitty.admin";
    public static final String QUERY_CREATION_WIKITTY_DATA_TEST = "jdbc.queries.creation.wikitty.data.test";
    public static final String QUERY_CREATION_WIKITTY_DATA = "jdbc.queries.creation.wikitty.data";
    public static final String QUERY_INSERT_WIKITTY_ADMIN = "jdbc.queries.insert.wikitty.admin";
    public static final String QUERY_UPDATE_WIKITTY_ADMIN = "jdbc.queries.update.wikitty.admin";
    public static final String QUERY_INSERT_WIKITTY_DATA = "jdbc.queries.insert.wikitty.data";
    public static final String QUERY_DELETE_WIKITTY_ADMIN = "jdbc.queries.delete.wikitty.admin";
    public static final String QUERY_DELETE_WIKITTY_DATA = "jdbc.queries.delete.wikitty.data";
    public static final String QUERY_CLEAR_EXTENSION = "jdbc.queries.clear.extension";
    public static final String QUERY_CLEAR_WIKITTY = "jdbc.queries.clear.wikitty";
    public static final String QUERY_CREATION_EXTENSION_ADMIN_TEST = "jdbc.queries.creation.extension.admin.test";
    public static final String QUERY_CREATION_EXTENSION_ADMIN = "jdbc.queries.creation.extension.admin";
    public static final String QUERY_CREATION_EXTENSION_DATA_TEST = "jdbc.queries.creation.extension.data.test";
    public static final String QUERY_CREATION_EXTENSION_DATA = "jdbc.queries.creation.extension.data";
    public static final String QUERY_INSERT_EXTENSION_ADMIN = "jdbc.queries.insert.extension.admin";
    public static final String QUERY_INSERT_EXTENSION_DATA = "jdbc.queries.insert.extension.data";
    protected static String JDBC_DRIVER = "jdbc.con.driver";
    protected static String JDBC_HOST = "jdbc.con.host";
    protected static String JDBC_USER_NAME = "jdbc.con.userName";
    protected static String JDBC_PASSWORD = "jdbc.con.password";
    protected static String JDBC_XADATASOURCE = "jdbc.xadatasource";
    protected static String TABLE_WIKITTY_ADMIN = "wikitty_admin";
    protected static String TABLE_WIKITTY_DATA = "wikitty_data";
    protected static String TABLE_EXTENSION_ADMIN = "extension_admin";
    protected static String TABLE_EXTENSION_DATA = "extension_data";
    private static Map<String, BasicManagedDataSource> dataSources = new HashMap<String, BasicManagedDataSource>();

    public static synchronized Properties loadProperties(Properties properties) {
        Properties queryConfig = new Properties();
        Properties databaseConfig = new Properties(queryConfig);
        InputStream streamQuery = null;
        InputStream streamConfig = null;
        try {
            ClassLoader contextClassLoader;
            URL url = ClassLoader.getSystemResource("wikitty-jdbc-query.properties");
            if (url == null) {
                contextClassLoader = Thread.currentThread().getContextClassLoader();
                url = contextClassLoader.getResource("wikitty-jdbc-query.properties");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Reading resource from: " + url));
            }
            streamQuery = url.openStream();
            queryConfig.load(streamQuery);
            url = ClassLoader.getSystemResource("wikitty-jdbc-config.properties");
            if (url == null) {
                contextClassLoader = Thread.currentThread().getContextClassLoader();
                url = contextClassLoader.getResource("wikitty-jdbc-config.properties");
            }
            if (url == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"No wikitty-jdbc-config.properties file found in classpath (skip default configuration loading)");
                }
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Reading resource from: " + url));
                }
                streamConfig = url.openStream();
                databaseConfig.load(streamConfig);
            }
            if (properties != null) {
                databaseConfig.putAll((Map<?, ?>)properties);
            }
        }
        catch (IOException eee) {
            try {
                throw new WikittyException("Unable to load property file", (Throwable)eee);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(streamQuery);
                IOUtils.closeQuietly(streamConfig);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)streamQuery);
        IOUtils.closeQuietly((InputStream)streamConfig);
        return databaseConfig;
    }

    public static synchronized Connection getConnection(Properties conf) {
        try {
            BasicManagedDataSource dataSource;
            TransactionManager transactionManager = com.arjuna.ats.jta.TransactionManager.transactionManager();
            String jdbcUrl = String.format("%s:%s@%s", conf.getProperty(JDBC_USER_NAME), conf.getProperty(JDBC_PASSWORD), conf.getProperty(JDBC_HOST));
            if (!dataSources.containsKey(jdbcUrl)) {
                log.info((Object)("Creating BasicManagedDataSource for: " + jdbcUrl));
                dataSource = new BasicManagedDataSource();
                String xaDataSourceClassName = conf.getProperty(JDBC_XADATASOURCE);
                if (xaDataSourceClassName != null) {
                    XADataSource xaDataSource = (XADataSource)Class.forName(xaDataSourceClassName).newInstance();
                    BeanMap beanMap = new BeanMap((Object)xaDataSource);
                    Set fields = beanMap.keySet();
                    for (Map.Entry<Object, Object> properties : conf.entrySet()) {
                        String propertyName = (String)properties.getKey();
                        if (!propertyName.startsWith(JDBC_XADATASOURCE + "." + xaDataSourceClassName + ".")) continue;
                        if (fields.contains(propertyName = propertyName.replaceFirst(JDBC_XADATASOURCE + "." + xaDataSourceClassName + ".", ""))) {
                            String propertyValue = (String)properties.getValue();
                            BeanUtils.setProperty((Object)xaDataSource, (String)propertyName, (Object)propertyValue);
                            continue;
                        }
                        log.warn((Object)("Invalid property " + propertyName + " for XADatasource " + Arrays.toString(fields.toArray())));
                    }
                    dataSource.setXaDataSourceInstance(xaDataSource);
                } else {
                    log.warn((Object)"No xadatasource is used, data integrity is not guarantee");
                }
                dataSource.setDriverClassName(conf.getProperty(JDBC_DRIVER));
                dataSource.setUrl(conf.getProperty(JDBC_HOST));
                dataSource.setUsername(conf.getProperty(JDBC_USER_NAME));
                dataSource.setPassword(conf.getProperty(JDBC_PASSWORD));
                dataSource.setTransactionManager(transactionManager);
                dataSources.put(jdbcUrl, dataSource);
            }
            dataSource = dataSources.get(jdbcUrl);
            Connection connection = dataSource.getConnection();
            return connection;
        }
        catch (Exception eee) {
            throw new WikittyException((Throwable)eee);
        }
    }

    public static void closeQuietly(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException e) {
            log.error((Object)"SQLException while closing connection", (Throwable)e);
        }
    }

    public static synchronized Connection getJDBCConnection(Properties conf) {
        try {
            Connection connection = WikittyJDBCUtil.getConnection(conf);
            connection.setAutoCommit(false);
            return connection;
        }
        catch (SQLException eee) {
            throw new WikittyException((Throwable)eee);
        }
    }

    public static void commitJDBCConnection(Connection connection) {
        try {
            connection.commit();
        }
        catch (SQLException eee) {
            throw new WikittyException((Throwable)eee);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException eee) {
                throw new WikittyException((Throwable)eee);
            }
        }
    }

    public static void rollbackJDBCConnection(Connection connection) {
        try {
            connection.rollback();
        }
        catch (SQLException eee) {
            throw new WikittyException((Throwable)eee);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException eee) {
                throw new WikittyException((Throwable)eee);
            }
        }
    }

    public static void doQuery(Connection connection, String query, Object ... args) throws SQLException {
        PreparedStatement sta = connection.prepareStatement(query);
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof Date) {
                sta.setObject(i + 1, args[i], 93);
                continue;
            }
            sta.setObject(i + 1, args[i]);
        }
        sta.execute();
    }
}

