/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.hessian;

import java.util.Properties;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyExtensionStorage;
import org.nuiton.wikitty.WikittySearchEngin;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceCached;
import org.nuiton.wikitty.WikittyServiceDelegator;
import org.nuiton.wikitty.WikittyServiceImpl;
import org.nuiton.wikitty.WikittyServiceNotifier;
import org.nuiton.wikitty.WikittyServiceSecurity;
import org.nuiton.wikitty.WikittyStorage;
import org.nuiton.wikitty.jdbc.WikittyExtensionStorageJDBC;
import org.nuiton.wikitty.jdbc.WikittyStorageJDBC;
import org.nuiton.wikitty.solr.WikittySearchEnginSolr;

public class WikittyServiceHessianDelegator
extends WikittyServiceDelegator {
    protected static final String WIKITTY_HESSIAN_CONFIGURATION_FILE = "wikitty-hessian.properties";

    public WikittyServiceHessianDelegator() throws WikittyException {
        try {
            ApplicationConfig config = new ApplicationConfig();
            config.setConfigFileName(WIKITTY_HESSIAN_CONFIGURATION_FILE);
            config.parse(new String[0]);
            Properties properties = config.getFlatOptions();
            WikittyExtensionStorageJDBC extensionStorage = new WikittyExtensionStorageJDBC(properties);
            WikittyStorageJDBC wikittyStorage = new WikittyStorageJDBC((WikittyExtensionStorage)extensionStorage, properties);
            WikittySearchEnginSolr searchEngin = new WikittySearchEnginSolr((WikittyExtensionStorage)extensionStorage, properties);
            WikittyServiceImpl service = new WikittyServiceImpl((WikittyExtensionStorage)extensionStorage, (WikittyStorage)wikittyStorage, (WikittySearchEngin)searchEngin);
            if (config.getOptionAsBoolean("wikitty.hessian.usesecurity")) {
                service = new WikittyServiceSecurity((WikittyService)service);
            }
            if (config.getOptionAsBoolean("wikitty.hessian.usecache")) {
                service = new WikittyServiceCached((WikittyService)service, properties);
            }
            if (config.getOptionAsBoolean("wikitty.hessian.usenotification")) {
                service = new WikittyServiceNotifier((WikittyService)service, properties);
            }
            this.setDelegate((WikittyService)service);
        }
        catch (Exception eee) {
            throw new WikittyException("Can't get delegate proxy", eee);
        }
    }
}

