package org.nuiton.wikitty.generator;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;





/**
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.wikitty.generator.WikittyImplementationGenerator"
 */
public class WikittyImplementationGenerator extends ObjectModelTransformerToJava {

    protected Map<ObjectModelClass, ObjectModelClass> processedClasses =
                              new HashMap<ObjectModelClass, ObjectModelClass>();
    
    @Override
    public void transformFromClass(ObjectModelClass clazz) {

        if ( WikittyTransformerUtil.isBusinessEntity(clazz) ) {
            ObjectModelClass implementation = prepareImplementation(clazz);
            processBusinessEntity(clazz, implementation);
        }

        if ( WikittyTransformerUtil.isBusinessEntity(clazz) ) {
            ObjectModelClass implementation = prepareImplementation(clazz);
            processMetaExtension(clazz, implementation);
        }
    }

    protected ObjectModelClass prepareImplementation(ObjectModelClass clazz) {
        ObjectModelClass implementation;
        
        if (processedClasses.containsKey(clazz)) {
            // class has been already processed, return the implementation
            implementation = processedClasses.get(clazz);
        } else {
            implementation = createClass(
                    WikittyTransformerUtil.businessEntityToImplementationName(clazz),
                    clazz.getPackageName());
            
            // TODO 20100811 bleny remove unused imports
            addImport(implementation, WikittyTransformerUtil.BUSINESS_ENTITY_CLASS_FQN);
            addImport(implementation, WikittyTransformerUtil.BUSINESS_ENTITY_WIKITTY_CLASS_FQN);
            addImport(implementation, WikittyTransformerUtil.WIKITTY_CLASS_FQN);
            addImport(implementation, "org.nuiton.wikitty.WikittyExtension");
            addImport(implementation, "org.nuiton.wikitty.WikittyUtil");
            addImport(implementation, "org.nuiton.wikitty.WikittyUser");
            addImport(implementation, "org.nuiton.wikitty.WikittyUserAbstract");
            addImport(implementation, "org.nuiton.wikitty.WikittyUserImpl");
            addImport(implementation, "org.nuiton.wikitty.TreeNode");
            addImport(implementation, "org.nuiton.wikitty.TreeNodeAbstract");
            addImport(implementation, "org.nuiton.wikitty.TreeNodeImpl");
            addImport(implementation, java.util.List.class);
            addImport(implementation, java.util.ArrayList.class);
            addImport(implementation, java.util.Collection.class);
            addImport(implementation, java.util.Collections.class);
            addImport(implementation, java.util.Set.class);
            addImport(implementation, java.util.Date.class);
            addImport(implementation, java.util.LinkedHashSet.class);
            
            setSuperClass(implementation, WikittyTransformerUtil.businessEntityToAbstractName(clazz));
            
            // adding a generated serialVersionUID
            Random random = new Random();
            Long serialVersionUIDs = random.nextLong();
            addConstant(implementation,
            "serialVersionUID",
            "long",
            serialVersionUIDs.toString() + "L",
            ObjectModelModifier.PRIVATE);
            
        }
        
        return implementation;
    }
    
    protected void processBusinessEntity(ObjectModelClass clazz,
                                         ObjectModelClass implementation) {
        
        // adding constructor
        ObjectModelOperation constructor = addConstructor(implementation, ObjectModelModifier.PUBLIC);
        setOperationBody(constructor, ""
+"\n"
+"        super();\n"
+"");

        constructor = addConstructor(implementation, ObjectModelModifier.PUBLIC);
        addParameter(constructor, WikittyTransformerUtil.WIKITTY_CLASS_FQN, "wikitty");
        setOperationBody(constructor, ""
+"\n"
+"        super(wikitty);\n"
+"");

        constructor = addConstructor(implementation, ObjectModelModifier.PUBLIC);
        addParameter(constructor, WikittyTransformerUtil.BUSINESS_ENTITY_WIKITTY_CLASS_FQN, "businessEntityWikitty");
        setOperationBody(constructor, ""
+"\n"
+"        super(businessEntityWikitty.getWikitty());\n"
+"");

    }

    protected void processMetaExtension(ObjectModelClass metaExtension,
                                        ObjectModelClass implementation) {


        ObjectModelOperation constructor = addConstructor(implementation, ObjectModelModifier.PUBLIC);
        addParameter(constructor, WikittyTransformerUtil.WIKITTY_EXTENSION_CLASS_FQN, "extension");
        addParameter(constructor, WikittyTransformerUtil.WIKITTY_CLASS_FQN, "wikitty");
        String contractName = WikittyTransformerUtil.businessEntityToContractName(metaExtension);
        setOperationBody(constructor, ""
+"\n"
+"        this.wikitty = wikitty;\n"
+"        addMetaExtension(extension"+contractName+", extension);\n"
+"");
    }
}
