package org.nuiton.wikitty.generator;

import java.util.HashSet;
import java.util.Set;

import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;

public class EugengoUtils extends GeneratorUtil {

    /**
     * Cherches et renvoie le copyright a utiliser sur le model.
     *
     * @param model le modele utilise
     * @return le texte du copyright ou null
     */
    public static String getCopyright(Model model) {
        return GeneratorUtil.findTagValue(EugengoConstants.TAG_COPYRIGHT, null, model);
    }

	public static boolean isService(ObjectModelClassifier classifier) {
		return hasStereotype(classifier, EugengoConstants.STEREOTYPE_SERVICE) || isCrudService(classifier);
	}

	public static boolean isCrudService(ObjectModelClassifier classifier) {
		return hasStereotype(classifier, EugengoConstants.STEREOTYPE_CRUD_SERVICE);
	}

	public static boolean isWebService(ObjectModelClassifier classifier) {
		// any crud service is remote
		if (isCrudService(classifier)) {
			return true;
		}
		// cannot be a webservice if class is not a service
		if (!isService(classifier)) {
			return false;
		}
		// Look for an operation that has the stereotype remote
		for (ObjectModelOperation op : classifier.getOperations()) {
			if (isRemote(op)) {
				return true;
			}
		}
		return false;
	}

	public static boolean isDto(ObjectModelClassifier classifier) {
		return hasStereotype(classifier, EugengoConstants.STEREOTYPE_DTO);
	}
	
	public static boolean isBusinessEntity(ObjectModelClassifier classifier) {
		return hasStereotype(classifier, EugengoConstants.STEREOTYPE_BUSINESS_ENTITY);
	}

	public static boolean isDao(ObjectModelClassifier classifier) {
		return hasStereotype(classifier, EugengoConstants.STEREOTYPE_DAO);
	}

	public static boolean isEntity(ObjectModelClassifier classifier) {
		return hasStereotype(classifier, EugengoConstants.STEREOTYPE_ENTITY);
	}

	public static boolean isException(ObjectModelClassifier classifier) {
		return hasStereotype(classifier, EugengoConstants.STEREOTYPE_EXCEPTION) || isBusinessException(classifier);
	}

    public static boolean isBusinessException(ObjectModelClassifier classifier) {
        return hasStereotype(classifier, EugengoConstants.STEREOTYPE_BUSINESS_EXCEPTION);
    }

	public static boolean isRemote(ObjectModelOperation op) {
		return hasStereotype(op, EugengoConstants.STEREOTYPE_REMOTE);
	}

	private static Set<String> simpleTypes;
	static {
		simpleTypes = new HashSet<String>();
		simpleTypes.add("void");
		simpleTypes.add("boolean");
		simpleTypes.add("byte");
		simpleTypes.add("short");
		simpleTypes.add("int");
		simpleTypes.add("long");
		simpleTypes.add("float");
		simpleTypes.add("double");
	}


    private static Set<String> primitiveTypes;
    static {
        primitiveTypes = new HashSet<String>();
        primitiveTypes.add("byte");
        primitiveTypes.add("Byte");
        primitiveTypes.add("short");
        primitiveTypes.add("Short");
        primitiveTypes.add("int");
        primitiveTypes.add("Integer");
        primitiveTypes.add("long");
        primitiveTypes.add("Long");
        primitiveTypes.add("float");
        primitiveTypes.add("Float");
        primitiveTypes.add("double");
        primitiveTypes.add("Double");
    
        primitiveTypes.add("char");
        primitiveTypes.add("Char");
    
        primitiveTypes.add("boolean");
        primitiveTypes.add("Boolean");
    }

	public static String extractModelName(Model model) {
		String result = model.getName();
		if (result.contains("::")) {
			result = result.replaceAll("::", ".");
		}
		if (result.endsWith(".")) {
			result = result.substring(0, result.length() - 1);
		}
		return result;
	}

	public static String normalizeCapitalName(String name) {
		String result = "";
		for (int idx = 0; idx < name.length(); idx++) {
			char c = name.charAt(idx);
			if (Character.isUpperCase(c)) {
				result += "_";
			}
			result += Character.toUpperCase(c);
		}
		if (result.startsWith("_")) {
			result = result.substring(1);
		}
		return result;
	}

	public static String getTagValue(ObjectModelAttribute attr, String tagName, String defaultValue) {
		String value = attr.getTagValue(tagName);
		if (value == null) {
			value = defaultValue;
		}
		return value;
	}

    public static boolean isPrimitiveType(ObjectModelAttribute attr) {
        String type = attr.getType();
        if (type.startsWith("java.lang.")) {
            type = type.substring(11);
        }
        return primitiveTypes.contains(type);
    }

} //EugengoUtils
