/*
 * #%L
 * Wikitty :: dto
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2010 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.nuiton.wikitty.WikittyException;

public class WikittyHookDTO implements WikittyHook {

@WikittyField(fqn="WikittyHook.name")    protected String name;

@WikittyField(fqn="WikittyHook.actionToHook")    protected Set<String> actionToHook = new LinkedHashSet<String>();

@WikittyField(fqn="WikittyHook.script")    protected String script;

@WikittyField(fqn="WikittyHook.mimetype")    protected String mimetype;

    protected String wikittyId;

    protected int modificationCount = 0;

    protected String wikittyVersion;

    @Override
    public String getName() {
        return name;
}

    @Override
    public void setName(String name) {
        this.name=name;
        modificationCount++;
}

    @Override
    public Set<String> getActionToHook() {
        return actionToHook;
}

    @Override
    public void setActionToHook(Set<String> actionToHook) {
        if (actionToHook == null){
            this.actionToHook = new LinkedHashSet<String>();
        } else {
            // make copy to prevent modification of source collection
            this.actionToHook=new LinkedHashSet<String>(actionToHook);
        }
        modificationCount++;
}

    @Override
    public void addAllActionToHook(Collection<String> actionToHook) {
        if (this.actionToHook == null){
            this.actionToHook = new LinkedHashSet<String>();
        }
        this.actionToHook.addAll(actionToHook);
        modificationCount++;
}

    @Override
    public void addActionToHook(String... element) {
        if (this.actionToHook == null){
            this.actionToHook = new LinkedHashSet<String>();
        }
        for (String v : element) {
            this.actionToHook.add(v);
        }
        modificationCount++;
}

    @Override
    public void removeActionToHook(String... element) {
        if (this.actionToHook != null) {
            for (String v : element) {
                actionToHook.remove(element);
            }
            modificationCount++;
        }
}

    @Override
    public void clearActionToHook() {
        if (this.actionToHook != null) {
            actionToHook.clear();
            modificationCount++;
        }
}

    @Override
    public String getScript() {
        return script;
}

    @Override
    public void setScript(String script) {
        this.script=script;
        modificationCount++;
}

    @Override
    public String getMimetype() {
        return mimetype;
}

    @Override
    public void setMimetype(String mimetype) {
        this.mimetype=mimetype;
        modificationCount++;
}

    public WikittyHookDTO() {
}

    public WikittyHookDTO(String wikittyId) {
        this.wikittyId=wikittyId;
}

    @Override
    public String toString() {
        return "dto:"+getWikittyId()+":"+getWikittyVersion();
}

    @Override
    public String getWikittyId() {
        return wikittyId;
}

    public void setWikittyId(String wikittyId) {
        this.wikittyId=wikittyId;
}

    @Override
    public String getWikittyVersion() {
        String result = wikittyVersion;
        if (modificationCount > 0) {
            result += "." + modificationCount;
        }
        return result;
}

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion=wikittyVersion;
        modificationCount=0;
}

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void copyFrom(BusinessEntity source) {
        if (!(source instanceof WikittyHook)){
            throw new WikittyException("Can't copy source object " + source +
                    ". They are not of the same type");
        }

        WikittyHook sourceCopy = (WikittyHook)source;

        setName(sourceCopy.getName());

        Set<String> actionToHook = sourceCopy.getActionToHook();
        if (actionToHook != null){
            setActionToHook(new LinkedHashSet<String>(actionToHook));
        }

        setScript(sourceCopy.getScript());

        setMimetype(sourceCopy.getMimetype());

        setWikittyVersion(sourceCopy.getWikittyVersion());
}

} //WikittyHookDTO
