/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceFactory;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryResult;
import org.nuiton.wikitty.query.WikittyQueryResultTreeNode;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.FacetTopic;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.search.TreeNodeResult;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyListener;

public class WikittyServiceTransaction
implements WikittyService {
    private static Log log = LogFactory.getLog(WikittyServiceTransaction.class);
    protected WikittyService ws;
    protected WikittyService tx;
    protected List<WikittyEvent> events;
    protected int autoCommit = -1;

    public WikittyServiceTransaction(ApplicationConfig config, WikittyService ws) {
        this.ws = ws;
        this.tx = WikittyServiceFactory.buildWikittyServiceTransaction(config);
        this.events = new LinkedList<WikittyEvent>();
    }

    public void setAutoCommit(int autoCommit) {
        this.autoCommit = autoCommit;
    }

    public int getAutoCommit() {
        return this.autoCommit;
    }

    protected void addEvent(String securityToken, WikittyEvent e) {
        this.events.add(e);
        if (this.autoCommit > 0 && this.events.size() >= this.autoCommit) {
            this.commit(securityToken);
        }
    }

    public void commit(String securityToken) {
        this.ws.replay(securityToken, this.events, false);
        this.tx.clear(null);
        this.events.clear();
    }

    public void commit(String securityToken, boolean force) {
        this.ws.replay(securityToken, this.events, force);
        this.tx.clear(null);
        this.events.clear();
    }

    public void rollback(String securityToken) {
        this.tx.clear(null);
        this.events.clear();
    }

    @Override
    public void addWikittyServiceListener(WikittyListener listener, WikittyService.ServiceListenerType type) {
        throw new UnsupportedOperationException("You try to add listener on WikittyServiceTransaction,this is an error desgin, you must add WikittyServiceNotifierfront of your WikittyServiceTransaction.");
    }

    @Override
    public void removeWikittyServiceListener(WikittyListener listener, WikittyService.ServiceListenerType type) {
        throw new UnsupportedOperationException("You try to remove listener on WikittyServiceTransaction,this is an error desgin, you must add WikittyServiceNotifierfront of your WikittyServiceTransaction.");
    }

    @Override
    public String login(String login, String password) {
        return this.ws.login(login, password);
    }

    @Override
    public void logout(String securityToken) {
        this.ws.logout(securityToken);
    }

    @Override
    public WikittyEvent clear(String securityToken) {
        WikittyEvent e = this.tx.clear(securityToken);
        this.addEvent(securityToken, e);
        return e;
    }

    @Override
    public boolean canWrite(String securityToken, Wikitty wikitty) {
        return true;
    }

    @Override
    public boolean canDelete(String securityToken, String wikittyId) {
        return true;
    }

    @Override
    public boolean canRead(String securityToken, String wikittyId) {
        boolean result = this.tx.exists(securityToken, wikittyId);
        if (!result) {
            result = this.ws.canRead(securityToken, wikittyId);
        }
        return result;
    }

    @Override
    public WikittyEvent replay(String securityToken, List<WikittyEvent> events, boolean force) {
        WikittyEvent e = this.tx.replay(securityToken, events, force);
        events.add(e);
        return e;
    }

    @Override
    public WikittyEvent store(String securityToken, Collection<Wikitty> wikitties, boolean force) {
        WikittyEvent e = this.tx.store(securityToken, wikitties, force);
        this.addEvent(securityToken, e);
        return e;
    }

    @Override
    public List<String> getAllExtensionIds(String securityToken) {
        HashSet<String> tmp = new HashSet<String>();
        tmp.addAll(this.tx.getAllExtensionIds(securityToken));
        tmp.addAll(this.ws.getAllExtensionIds(securityToken));
        ArrayList<String> result = new ArrayList<String>(tmp);
        return result;
    }

    @Override
    public List<String> getAllExtensionsRequires(String securityToken, String extensionName) {
        HashSet<String> tmp = new HashSet<String>();
        tmp.addAll(this.tx.getAllExtensionsRequires(securityToken, extensionName));
        tmp.addAll(this.ws.getAllExtensionsRequires(securityToken, extensionName));
        ArrayList<String> result = new ArrayList<String>(tmp);
        return result;
    }

    @Override
    public WikittyEvent storeExtension(String securityToken, Collection<WikittyExtension> exts) {
        WikittyEvent e = this.tx.storeExtension(securityToken, exts);
        this.addEvent(securityToken, e);
        return e;
    }

    @Override
    public WikittyEvent deleteExtension(String securityToken, Collection<String> extNames) {
        WikittyEvent e = this.tx.deleteExtension(securityToken, extNames);
        this.addEvent(securityToken, e);
        return e;
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, String extensionId) {
        WikittyExtension result = this.tx.restoreExtension(securityToken, extensionId);
        if (result == null) {
            result = this.ws.restoreExtension(securityToken, extensionId);
        }
        return result;
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken, String name) {
        WikittyExtension result = this.tx.restoreExtensionLastVersion(securityToken, name);
        if (result == null) {
            result = this.ws.restoreExtensionLastVersion(securityToken, name);
        }
        return result;
    }

    @Override
    public List<WikittyExtension> restoreExtensionAndDependenciesLastVesion(String securityToken, Collection<String> extensionNames) {
        ArrayList<WikittyExtension> result = new ArrayList<WikittyExtension>();
        for (String extName : extensionNames) {
            WikittyExtension ext = this.restoreExtensionLastVersion(securityToken, extName);
            if (ext == null) continue;
            List<String> requires = ext.getRequires();
            if (CollectionUtils.isNotEmpty(requires)) {
                List<WikittyExtension> dependencies = this.restoreExtensionAndDependenciesLastVesion(securityToken, requires);
                result.addAll(dependencies);
            }
            result.add(ext);
        }
        return result;
    }

    @Override
    public List<Wikitty> restore(String securityToken, List<String> ids) {
        List<Wikitty> resultWS = this.ws.restore(securityToken, ids);
        List<Wikitty> resultTx = this.tx.restore(securityToken, ids);
        Wikitty[] result = resultWS.toArray(new Wikitty[resultWS.size()]);
        int i = 0;
        for (Wikitty w : resultTx) {
            String id = ids.get(i);
            if (w != null || this.tx.exists(securityToken, id)) {
                result[i] = w;
            }
            ++i;
        }
        return Arrays.asList(result);
    }

    @Override
    public WikittyEvent delete(String securityToken, Collection<String> ids) {
        List<Wikitty> wikitties = this.ws.restore(securityToken, new ArrayList<String>(ids));
        this.tx.store(securityToken, wikitties, true);
        WikittyEvent e = this.tx.delete(securityToken, ids);
        this.addEvent(securityToken, e);
        return e;
    }

    @Override
    public List<PagedResult<String>> findAllByCriteria(String securityToken, List<Criteria> criteria) {
        List<PagedResult<String>> resultTxList = this.tx.findAllByCriteria(securityToken, criteria);
        List<PagedResult<String>> resultWsList = this.ws.findAllByCriteria(securityToken, criteria);
        ArrayList<PagedResult<String>> result = new ArrayList<PagedResult<String>>(resultWsList.size());
        for (int i = 0; i < criteria.size(); ++i) {
            PagedResult<String> resultTx = resultTxList.get(i);
            PagedResult<String> resultWs = resultWsList.get(i);
            LinkedHashSet<String> ids = new LinkedHashSet<String>(resultTx.size() + resultWs.size());
            ids.addAll(resultTx.getAll());
            for (String id : resultWs.getAll()) {
                if (this.tx.exists(securityToken, id) && this.tx.isDeleted(securityToken, id)) continue;
                ids.add(id);
            }
            String criteriaName = resultWs.getCriteriaName();
            int firstIndice = resultWs.getFirstIndice();
            int numFound = resultTx.getNumFound() + resultWs.getNumFound();
            String queryString = resultWs.getQueryString();
            Map<String, List<FacetTopic>> facets = resultWs.getFacets();
            ArrayList results = new ArrayList(ids);
            result.add(new PagedResult(criteriaName, firstIndice, numFound, queryString, facets, results));
        }
        if (criteria.size() != result.size()) {
            log.error((Object)String.format("Criteria input list (%s) has not same size that result list (%s)", criteria.size(), result.size()));
        }
        return result;
    }

    @Override
    public List<String> findByCriteria(String securityToken, List<Criteria> criteria) {
        ArrayList<String> result = new ArrayList<String>(criteria.size());
        ArrayList<Criteria> criteriaLimit = new ArrayList<Criteria>(criteria.size());
        for (Criteria c : criteria) {
            Criteria climit = Search.query(c).criteria().setFirstIndex(0).setEndIndex(1);
            criteriaLimit.add(climit);
        }
        List<PagedResult<String>> idsList = this.findAllByCriteria(securityToken, criteriaLimit);
        for (PagedResult<String> ids : idsList) {
            if (ids.size() > 0) {
                result.add(ids.getFirst());
                continue;
            }
            result.add(null);
        }
        if (criteria.size() != result.size()) {
            log.error((Object)String.format("Criteria input list (%s) has not same size that result list (%s)", criteria.size(), result.size()));
        }
        return result;
    }

    @Override
    public TreeNodeResult<String> findTreeNode(String securityToken, String wikittyId, int depth, boolean count, Criteria filter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<WikittyQueryResult<Map<String, Object>>> findAllByQuery(String securityToken, List<WikittyQuery> queries) {
        List<WikittyQueryResult<Map<String, Object>>> resultTxList = this.tx.findAllByQuery(securityToken, queries);
        List<WikittyQueryResult<Map<String, Object>>> resultWsList = this.ws.findAllByQuery(securityToken, queries);
        ArrayList<WikittyQueryResult<Map<String, Object>>> result = new ArrayList<WikittyQueryResult<Map<String, Object>>>(resultWsList.size());
        for (int i = 0; i < queries.size(); ++i) {
            WikittyQueryResult<Map<String, Object>> resultTx = resultTxList.get(i);
            WikittyQueryResult<Map<String, Object>> resultWs = resultWsList.get(i);
            LinkedHashSet<Map<String, Object>> ids = new LinkedHashSet<Map<String, Object>>(resultTx.size() + resultWs.size());
            ids.addAll(resultTx.getAll());
            for (Map<String, Object> map : resultWs.getAll()) {
                String id = (String)map.get(Element.ID.getValue());
                if (!this.tx.exists(securityToken, id) || !this.tx.isDeleted(securityToken, id)) {
                    ids.add(map);
                    continue;
                }
                ids.add(map);
            }
            String queryName = resultWs.getQueryName();
            int firstIndice = resultWs.getOffset();
            int numFound = resultTx.getTotalResult() + resultWs.getTotalResult();
            String queryString = resultWs.getQueryString();
            Map<String, List<org.nuiton.wikitty.query.FacetTopic>> facets = resultWs.getFacets();
            ArrayList results = new ArrayList(ids);
            long timeQuery = resultTx.getTimeQuery() + resultWs.getTimeQuery();
            result.add(new WikittyQueryResult(queryName, firstIndice, numFound, queryString, facets, results, timeQuery, 0L));
        }
        if (queries.size() != result.size()) {
            log.error((Object)String.format("Queries input list (%s) has not same size that result list (%s)", queries.size(), result.size()));
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> findByQuery(String securityToken, List<WikittyQuery> queries) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(queries.size());
        ArrayList<WikittyQuery> queriesLimited = new ArrayList<WikittyQuery>(queries.size());
        for (WikittyQuery c : queries) {
            WikittyQuery climit = c.copy().setOffset(0).setLimit(1);
            queriesLimited.add(climit);
        }
        List<WikittyQueryResult<Map<String, Object>>> idsList = this.findAllByQuery(securityToken, queriesLimited);
        for (WikittyQueryResult<Map<String, Object>> ids : idsList) {
            if (ids.size() > 0) {
                result.add(ids.peek());
                continue;
            }
            result.add(null);
        }
        if (queries.size() != result.size()) {
            log.error((Object)String.format("Query input list (%s) has not same size that result list (%s)", queries.size(), result.size()));
        }
        return result;
    }

    @Override
    public WikittyQueryResultTreeNode<String> findTreeNode(String securityToken, String wikittyId, int depth, boolean count, WikittyQuery filter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public WikittyEvent deleteTree(String securityToken, String treeNodeId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Wikitty restoreVersion(String securityToken, String wikittyId, String version) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void syncSearchEngine(String securityToken) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean exists(String securityToken, String wikittyId) {
        boolean result = this.tx.exists(securityToken, wikittyId);
        if (!result && !this.tx.isDeleted(securityToken, wikittyId)) {
            result = this.ws.exists(securityToken, wikittyId);
        }
        return result;
    }

    @Override
    public boolean isDeleted(String securityToken, String wikittyId) {
        boolean result = this.tx.isDeleted(securityToken, wikittyId);
        if (!result && !this.tx.exists(securityToken, wikittyId)) {
            result = this.ws.isDeleted(securityToken, wikittyId);
        }
        return result;
    }
}

