/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.entities;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.WikittyTypes;
import org.nuiton.wikitty.generator.WikittyTagValue;

public class FieldType
implements WikittyTagValue,
Serializable {
    private static Log log = LogFactory.getLog(FieldType.class);
    private static final long serialVersionUID = -4375308750387837026L;
    public static final int NOLIMIT = Integer.MAX_VALUE;
    protected WikittyTypes type;
    protected int lowerBound;
    protected int upperBound;
    Map<String, String> tagValues = new HashMap<String, String>();

    public FieldType() {
    }

    public FieldType(WikittyTypes type, int lowerBound, int upperBound) {
        this.type = type;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public void addTagValue(String tag, String value) {
        this.tagValues.put(tag, value);
    }

    public String getTagValue(String tag) {
        String result = (String)StringUtils.defaultIfBlank((CharSequence)this.tagValues.get(tag), (CharSequence)"");
        return result;
    }

    public Set<String> getTagNames() {
        return this.tagValues.keySet();
    }

    public Map<String, String> getTagValues() {
        return this.tagValues;
    }

    public void setTagValues(Map<String, String> tagValues) {
        this.tagValues = tagValues;
    }

    public boolean isCollection() {
        return this.upperBound > 1;
    }

    public String toDefinition(String name) {
        String result = (Object)((Object)this.type) + " " + name;
        if (this.lowerBound != 0 || this.upperBound != 0) {
            result = this.upperBound != Integer.MAX_VALUE ? result + "[" + this.lowerBound + "-" + this.upperBound + "]" : result + "[" + this.lowerBound + "-*]";
        }
        result = result + WikittyUtil.tagValuesToString(this.tagValues);
        return result;
    }

    public Object getContainedValidObject(Object value) {
        Object result = null;
        switch (this.type) {
            case BINARY: {
                result = WikittyUtil.toBinary(value);
                break;
            }
            case DATE: {
                result = WikittyUtil.toDate(value);
                break;
            }
            case NUMERIC: {
                result = WikittyUtil.toBigDecimal(value);
                break;
            }
            case BOOLEAN: {
                result = WikittyUtil.toBoolean(value);
                break;
            }
            case STRING: {
                result = WikittyUtil.toString(value);
                break;
            }
            default: {
                result = WikittyUtil.toWikitty(value);
            }
        }
        return result;
    }

    public Object getValidValue(Object value) throws WikittyException {
        AbstractCollection result;
        if (value == null && this.isNotNull()) {
            throw new WikittyException("Value can't be null for this field");
        }
        if (value == null) {
            result = null;
        } else if (this.isCollection()) {
            if (!(value instanceof Collection) && !value.getClass().isArray()) {
                throw new WikittyException("A collection or array is expected for type " + this.type.name() + "[" + this.lowerBound + " - " + this.upperBound + "]");
            }
            AbstractCollection col = this.isUnique() ? new LinkedHashSet() : new ArrayList();
            if (value instanceof Collection) {
                for (Object o : (Collection)value) {
                    col.add(this.getContainedValidObject(o));
                }
            } else {
                for (Object o : (Object[])value) {
                    col.add(this.getContainedValidObject(o));
                }
            }
            result = col;
            if (this.getLowerBound() > col.size() || col.size() > this.getUpperBound()) {
                throw new WikittyException(String.format("Can't set collection value, bad size collection: %s <= %s <= %s is false", this.getLowerBound(), col.size(), this.getUpperBound()));
            }
        } else {
            result = this.getContainedValidObject(value);
        }
        return result;
    }

    public boolean isValidValue(Object value) {
        boolean result;
        if (value == null && this.isNotNull()) {
            result = false;
        } else {
            try {
                this.getValidValue(value);
                result = true;
            }
            catch (Exception eee) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Can't convert value, value is not valid, return false", (Throwable)eee);
                }
                result = false;
            }
        }
        return result;
    }

    public WikittyTypes getType() {
        return this.type;
    }

    public void setType(WikittyTypes type) {
        this.type = type;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(int lowerBound) {
        this.lowerBound = lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(int upperBound) {
        this.upperBound = upperBound;
    }

    public boolean isUnique() {
        return "true".equalsIgnoreCase(this.getTagValue("unique"));
    }

    public boolean isNotNull() {
        return "true".equalsIgnoreCase(this.getTagValue("notNull"));
    }

    public boolean isIndexed() {
        String indexed = this.getTagValue("indexed");
        boolean result = !this.isCrypted() && !StringUtils.equalsIgnoreCase((CharSequence)"false", (CharSequence)indexed);
        return result;
    }

    public boolean hasPattern() {
        boolean result = StringUtils.isNotBlank((CharSequence)this.getTagValue("pattern"));
        return result;
    }

    public String getPattern() {
        String result = this.getTagValue("pattern");
        return result;
    }

    public boolean isCrypted() {
        boolean result = StringUtils.isNotBlank((CharSequence)this.getTagValue("crypt"));
        return result;
    }

    public String getCryptAlgo() {
        String crypt = this.getTagValue("crypt");
        String result = StringUtils.substringBefore((String)crypt, (String)":");
        return result;
    }

    public String getCryptPassword() {
        String crypt = this.getTagValue("crypt");
        String result = StringUtils.substringAfter((String)crypt, (String)":");
        return result;
    }

    public String getSubtype() {
        String result = this.getTagValue("subtype");
        if (StringUtils.isBlank((CharSequence)result)) {
            switch (this.type) {
                case DATE: {
                    result = "";
                    break;
                }
                case NUMERIC: {
                    result = "real";
                    break;
                }
                case STRING: {
                    result = "monoline";
                }
            }
        }
        return result;
    }

    public String getAllowed() {
        String allowed = this.getTagValue("allowed");
        return allowed;
    }

    public String getAllowedQuery() {
        String allowed = this.getTagValue("allowedQuery");
        return allowed;
    }

    public String getChoice() {
        String result = this.getTagValue("choice");
        return result;
    }

    public String getChoiceQuery() {
        String result = this.getTagValue("choiceQuery");
        return result;
    }

    public String getMin() {
        String result = this.getTagValue("min");
        return result;
    }

    public String getMinQuery() {
        String result = this.getTagValue("minQuery");
        return result;
    }

    public String getMax() {
        String result = this.getTagValue("max");
        return result;
    }

    public String getMaxQuery() {
        String result = this.getTagValue("maxQuery");
        return result;
    }

    public List<String> getAllowedAsList() {
        List<String> result = null;
        String allowed = this.getAllowed();
        if (StringUtils.isNotBlank((CharSequence)allowed)) {
            String[] v = allowed.split("\\s*,\\s*");
            result = Arrays.asList(v);
        }
        return result;
    }

    public boolean isRestrited() {
        boolean result = this.hasAllowed() || this.hasAllowedQuery();
        return result;
    }

    public boolean hasAllowed() {
        boolean result = StringUtils.isNotBlank((CharSequence)this.getAllowed());
        return result;
    }

    public boolean hasAllowedQuery() {
        boolean result = StringUtils.isNotBlank((CharSequence)this.getAllowedQuery());
        return result;
    }

    public boolean hasChoice() {
        boolean result = StringUtils.isNotBlank((CharSequence)this.getChoice());
        return result;
    }

    public boolean hasChoiceQuery() {
        boolean result = StringUtils.isNotBlank((CharSequence)this.getChoiceQuery());
        return result;
    }

    public boolean hasMin() {
        boolean result = StringUtils.isNotBlank((CharSequence)this.getMin());
        return result;
    }

    public boolean hasMinQuery() {
        boolean result = StringUtils.isNotBlank((CharSequence)this.getMinQuery());
        return result;
    }

    public boolean hasMax() {
        boolean result = StringUtils.isNotBlank((CharSequence)this.getMax());
        return result;
    }

    public boolean hasMaxQuery() {
        boolean result = StringUtils.isNotBlank((CharSequence)this.getMaxQuery());
        return result;
    }
}

