/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: Like.java 1462 2012-04-05 15:31:15Z maven-release $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.7/wikitty-api/src/main/java/org/nuiton/wikitty/query/conditions/Like.java $
 * %%
 * Copyright (C) 2012 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.query.conditions;

import org.nuiton.wikitty.entities.Element;

/**
 * Like is use on String field type, you can use '*' at beginning or ending
 * to match all char. (ex: ext.field LIKE 'deb*' match 'debut' or 'debout' ...
 * <p>
 * comparaison is done in ignore case mode, if you wan't case sensitive
 * comparaison you must used {@link Equals}
 *
 * @author poussin
 * @version $Revision: 1462 $
 * @since 3.3
 *
 * Last update: $Date: 2012-04-05 17:31:15 +0200 (Thu, 05 Apr 2012) $
 * by : $Author: maven-release $
 */


public class Like extends TerminalBinaryOperator {
    // serialVersionUID is used for serialization.

    private static final long serialVersionUID = 1L;

    public Like(Element element) {
        super(element);
    }

    public Like(Element element, String value) {
        super(element, value);
    }

    public Like(Element element, ConditionValue value) {
        super(element, value);
    }
}
