/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.query.conditions;

import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.ObjectUtils;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.query.WikittyQueryVisitor;
import org.nuiton.wikitty.query.conditions.Condition;
import org.nuiton.wikitty.query.conditions.ConditionValue;
import org.nuiton.wikitty.query.conditions.ConditionValueString;
import org.nuiton.wikitty.query.conditions.TerminalOperator;

public abstract class TerminalTernaryOperator
extends TerminalOperator {
    private static final long serialVersionUID = 1L;
    protected Element element;
    protected ConditionValue min;
    protected ConditionValue max;

    public TerminalTernaryOperator(Element element) {
        this(element, (ConditionValue)null, (ConditionValue)null);
    }

    public TerminalTernaryOperator(Element element, String min, String max) {
        this(element, new ConditionValueString(min), new ConditionValueString(max));
    }

    public TerminalTernaryOperator(Element element, ConditionValue min, ConditionValue max) {
        this.element = element;
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean waitCondition() {
        boolean result = this.min == null || this.max == null;
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Condition addCondition(Condition c) {
        if (!this.waitCondition()) throw new WikittyException("TerminalTernaryOperator has already min and max value");
        if (!(c instanceof ConditionValue)) throw new WikittyException("Only ConditionValue can be add to TerminalTernaryOperator, but you try to add: " + ClassUtils.getShortCanonicalName((Object)c, (String)"null"));
        if (this.min == null) {
            this.min = (ConditionValue)c;
            return this;
        } else {
            this.max = (ConditionValue)c;
        }
        return this;
    }

    @Override
    public void accept(WikittyQueryVisitor visitor) {
        boolean walk = visitor.visitEnter(this);
        if (walk) {
            this.min.accept(visitor);
            walk = visitor.visitMiddle(this);
            if (walk) {
                this.max.accept(visitor);
            }
        }
        visitor.visitLeave(this, walk);
    }

    public Element getElement() {
        return this.element;
    }

    public ConditionValue getMin() {
        return this.min;
    }

    public ConditionValue getMax() {
        return this.max;
    }

    @Override
    boolean equalsDeep(Object other) {
        TerminalTernaryOperator op = (TerminalTernaryOperator)other;
        boolean result = ObjectUtils.equals((Object)this.getElement(), (Object)op.getElement()) && ObjectUtils.equals((Object)this.getMin(), (Object)op.getMin()) && ObjectUtils.equals((Object)this.getMax(), (Object)op.getMax());
        return result;
    }
}

