/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.layers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyAuthorisationAbstract;
import org.nuiton.wikitty.WikittyAuthorisationHelper;
import org.nuiton.wikitty.WikittyAuthorisationImpl;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyGroup;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittySecurityHelper;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceInMemory;
import org.nuiton.wikitty.WikittyServiceSecurity;
import org.nuiton.wikitty.WikittyUser;
import org.nuiton.wikitty.WikittyUserImpl;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.layers.AbstractWikittyServiceTest;

public class WikittyServiceSecurityTest
extends AbstractWikittyServiceTest {
    private static final Log log = LogFactory.getLog(WikittyServiceSecurityTest.class);
    protected WikittyServiceSecurity securityService;
    protected String noRightsToken;
    protected String readerToken;
    protected String writerToken;
    protected String adminToken;
    protected String ownerToken;

    @Before
    public void setUpWikittyServiceSecurityTest() {
        WikittyServiceInMemory inMemoryService = new WikittyServiceInMemory();
        this.securityService = new WikittyServiceSecurity((WikittyService)inMemoryService);
        this.service = this.securityService;
        this.token = null;
        WikittyProxy proxy = new WikittyProxy((WikittyService)this.securityService);
        proxy.setSecurityToken(this.token);
        WikittyUserImpl anonymous = new WikittyUserImpl();
        anonymous.setLogin("i have no rights");
        anonymous.setPassword("");
        proxy.store((BusinessEntity)anonymous);
        WikittyUserImpl reader = new WikittyUserImpl();
        reader.setLogin("reader");
        reader.setPassword("");
        proxy.store((BusinessEntity)reader);
        WikittyUserImpl writer = new WikittyUserImpl();
        writer.setLogin("writer");
        writer.setPassword("");
        proxy.store((BusinessEntity)writer);
        WikittyUserImpl admin = new WikittyUserImpl();
        admin.setLogin("admin");
        admin.setPassword("");
        proxy.store((BusinessEntity)admin);
        WikittyUserImpl owner = new WikittyUserImpl();
        owner.setLogin("owner");
        owner.setPassword("");
        proxy.store((BusinessEntity)owner);
        Wikitty authorizations = WikittySecurityHelper.createExtensionAuthorisation((WikittyUser)owner, (WikittyExtension)this.extension);
        WikittyAuthorisationHelper.addReader((Wikitty)authorizations, (String)reader.getWikittyId());
        WikittyAuthorisationHelper.addWriter((Wikitty)authorizations, (String)writer.getWikittyId());
        WikittyAuthorisationHelper.addAdmin((Wikitty)authorizations, (String)admin.getWikittyId());
        WikittyAuthorisationHelper.setOwner((Wikitty)authorizations, (String)owner.getWikittyId());
        log.debug((Object)("initial wikitty rights" + authorizations));
        this.securityService.storeExtension(this.token, this.extension);
        this.securityService.store(this.token, authorizations);
        this.token = null;
        this.ownerToken = this.service.login("owner", "");
        this.adminToken = this.service.login("admin", "");
        this.writerToken = this.service.login("writer", "");
        this.readerToken = this.service.login("reader", "");
        this.noRightsToken = this.service.login("i have no rights", "");
        WikittyUserImpl root = new WikittyUserImpl();
        root.setLogin("root");
        root.setPassword("");
        proxy.store((BusinessEntity)root);
        String rootToken = this.service.login("root", "");
        WikittyGroup appAdmin = WikittySecurityHelper.createAppAdminGroup((WikittyUser)root);
        proxy.store((BusinessEntity)appAdmin);
    }

    @Test
    public void testInvalidToken() {
        String invalidToken = WikittyUtil.genSecurityTokenId();
        try {
            this.service.store(invalidToken, this.aWikitty);
            Assert.fail();
        }
        catch (SecurityException e) {
            // empty catch block
        }
        this.service.store(this.readerToken, this.aWikitty);
        try {
            this.service.restore(invalidToken, this.aWikitty.getId());
            Assert.fail();
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            this.service.logout(invalidToken);
            Assert.fail();
        }
        catch (SecurityException e) {
            // empty catch block
        }
        this.service.logout(this.readerToken);
        try {
            this.service.store(this.readerToken, this.aWikitty);
            Assert.fail();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Test
    public void testReaderRightOnWikitty() {
        this.aWikitty.addExtension(WikittyAuthorisationAbstract.extensionWikittyAuthorisation);
        WikittyAuthorisationImpl auth = new WikittyAuthorisationImpl(this.aWikitty);
        WikittyProxy proxy = new WikittyProxy((WikittyService)this.securityService);
        String readerId = WikittySecurityHelper.getUserWikittyId((WikittyProxy)proxy, (String)"reader");
        auth.clearReader();
        auth.addReader(readerId);
        log.debug((Object)("will store wikitty" + this.aWikitty));
        this.service.store(this.ownerToken, this.aWikitty);
        try {
            Wikitty restoredWikitty = this.service.restore(null, this.aWikitty.getId());
            log.debug((Object)("restored wikitty is " + restoredWikitty));
            Assert.fail((String)"an exception should have been raised");
        }
        catch (SecurityException e) {
            log.info((Object)("raised exception : " + e));
        }
    }

    @Test
    public void testWriterRightOnWikitty() {
        this.aWikitty.addExtension(WikittyAuthorisationAbstract.extensionWikittyAuthorisation);
        WikittyAuthorisationImpl auth = new WikittyAuthorisationImpl(this.aWikitty);
        this.service.store(this.ownerToken, this.aWikitty);
        WikittyProxy proxy = new WikittyProxy((WikittyService)this.securityService);
        String adminId = WikittySecurityHelper.getUserWikittyId((WikittyProxy)proxy, (String)"admin");
        auth.clearReader();
        auth.clearWriter();
        auth.clearAdmin();
        auth.addAdmin(adminId);
        log.debug((Object)("will store wikitty" + this.aWikitty));
        try {
            this.service.store(this.writerToken, this.aWikitty);
            Assert.fail((String)"an exception should have been raised");
        }
        catch (SecurityException e) {
            log.info((Object)("raised exception : " + e));
        }
        Wikitty restoredWikitty = this.service.restore(null, this.aWikitty.getId());
        log.debug((Object)("restored wikitty is " + restoredWikitty));
        Assert.assertNotNull((Object)restoredWikitty);
    }

    @Test
    public void checkReaderRightOnExtension() {
        try {
            this.service.store(this.noRightsToken, this.aWikitty);
            Assert.fail((String)"an exception should have been raised");
        }
        catch (SecurityException e) {
            log.debug((Object)"creating a wikitty without rights", (Throwable)e);
        }
        try {
            this.service.restoreExtension(this.noRightsToken, this.extension.getId());
        }
        catch (SecurityException e) {
            Assert.fail((String)"no exception should have been raised");
        }
        try {
            this.service.restoreExtensionLastVersion(this.noRightsToken, this.extension.getName());
        }
        catch (SecurityException e) {
            Assert.fail((String)"no exception should have been raised");
        }
        try {
            this.service.store(this.readerToken, this.aWikitty);
            this.service.restoreExtension(this.readerToken, this.extension.getId());
            this.service.restoreExtensionLastVersion(this.readerToken, this.extension.getName());
        }
        catch (SecurityException e) {
            Assert.fail((String)"an exception has been raised");
        }
    }

    @Test
    public void checkWriterRightOnExtension() {
        FieldType fieldType = new FieldType(FieldType.TYPE.STRING, 0, 1);
        this.service.restoreExtensionLastVersion(this.writerToken, this.extension.getName());
        this.extension.addField("new_field", fieldType);
        try {
            this.service.storeExtension(this.readerToken, this.extension);
            Assert.fail((String)"an exception should have been raised");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            this.service.storeExtension(this.writerToken, this.extension);
        }
        catch (SecurityException e) {
            Assert.fail((String)"an exception has been raised");
        }
    }

    @Test
    public void checkAdminRightOnExtension() {
        WikittyProxy adminProxy = new WikittyProxy((WikittyService)this.securityService);
        adminProxy.setSecurityToken(this.adminToken);
        Wikitty extensionAuthorisation = WikittySecurityHelper.restoreExtensionAuthorisation((WikittyProxy)adminProxy, (WikittyExtension)this.extension);
        log.debug((Object)("initial rights " + extensionAuthorisation));
        WikittyAuthorisationHelper.clearReader((Wikitty)extensionAuthorisation);
        WikittyAuthorisationHelper.clearWriter((Wikitty)extensionAuthorisation);
        WikittyAuthorisationHelper.addWriter((Wikitty)extensionAuthorisation, (String)"ID1");
        WikittyAuthorisationHelper.setOwner((Wikitty)extensionAuthorisation, (String)"ID2");
        log.debug((Object)("will store rights " + extensionAuthorisation));
        try {
            this.securityService.store(this.writerToken, extensionAuthorisation);
            Assert.fail((String)"an exception should habe raised");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.securityService.store(this.adminToken, extensionAuthorisation);
        extensionAuthorisation = WikittySecurityHelper.restoreExtensionAuthorisation((WikittyProxy)adminProxy, (WikittyExtension)this.extension);
        log.debug((Object)("restored rights " + extensionAuthorisation));
        Assert.assertTrue((boolean)WikittyAuthorisationHelper.getReader((Wikitty)extensionAuthorisation).isEmpty());
        Assert.assertTrue((boolean)WikittyAuthorisationHelper.getWriter((Wikitty)extensionAuthorisation).contains("ID1"));
        Assert.assertEquals((long)1L, (long)WikittyAuthorisationHelper.getWriter((Wikitty)extensionAuthorisation).size());
        Assert.assertTrue((boolean)WikittyAuthorisationHelper.getOwner((Wikitty)extensionAuthorisation).contains("ID2"));
    }
}

