/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.layers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyAuthorisationHelper;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceInMemory;
import org.nuiton.wikitty.WikittyServiceSecurity;
import org.nuiton.wikitty.layers.AbstractWikittyServiceTest;

public class WikittyServiceSecurityTest
extends AbstractWikittyServiceTest {
    private static final Log log = LogFactory.getLog(WikittyServiceSecurityTest.class);
    protected static final String APPADMIN_LOGIN = "root";
    protected static final String APPADMIN_PASSWORD = "toto";
    protected WikittyServiceSecurity securityService;
    protected String noRightsToken;
    protected String readerToken;
    protected String writerToken;
    protected String adminToken;
    protected String ownerToken;

    @Before
    public void setUpWikittyServiceSecurityTest() {
        WikittyServiceInMemory inMemoryService = new WikittyServiceInMemory();
        this.securityService = new WikittyServiceSecurity((WikittyService)inMemoryService);
        this.service = this.securityService;
        this.token = this.service.login(APPADMIN_LOGIN, APPADMIN_PASSWORD);
        this.securityService.createAccount(this.token, "i have no rights", "");
        this.securityService.createAccount(this.token, "reader", "");
        this.securityService.createAccount(this.token, "writer", "");
        this.securityService.createAccount(this.token, "admin", "");
        this.securityService.createAccount(this.token, "owner", "");
        Wikitty authorizations = this.securityService.addWikittyAuthorisation(this.token, this.extension);
        WikittyAuthorisationHelper.addReader((Wikitty)authorizations, (String)this.securityService.getUserWikittyId(this.token, "reader"));
        WikittyAuthorisationHelper.addWriter((Wikitty)authorizations, (String)this.securityService.getUserWikittyId(this.token, "writer"));
        WikittyAuthorisationHelper.addAdmin((Wikitty)authorizations, (String)this.securityService.getUserWikittyId(this.token, "admin"));
        WikittyAuthorisationHelper.setOwner((Wikitty)authorizations, (String)this.securityService.getUserWikittyId(this.token, "owner"));
        log.debug((Object)("initial wikitty rights" + authorizations));
        this.service.store(this.token, authorizations);
        Wikitty extensionAuthorisation = this.securityService.restoreExtensionAuthorisation(this.token, this.extension);
        log.debug((Object)("restored initial rights " + extensionAuthorisation));
        this.service.logout(this.token);
        this.token = null;
        this.ownerToken = this.service.login("owner", "");
        this.adminToken = this.service.login("admin", "");
        this.writerToken = this.service.login("writer", "");
        this.readerToken = this.service.login("reader", "");
        this.noRightsToken = this.service.login("i have no rights", "");
    }

    @Test
    public void testInvalidToken() {
        String invalidToken = "INVALID TOKEN";
        try {
            this.service.store(invalidToken, this.aWikitty);
            Assert.fail();
        }
        catch (SecurityException e) {
            // empty catch block
        }
        this.token = this.service.login(APPADMIN_LOGIN, APPADMIN_PASSWORD);
        this.service.store(this.token, this.aWikitty);
        try {
            this.service.restore(invalidToken, this.aWikitty.getId());
            Assert.fail();
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            this.service.logout(invalidToken);
            Assert.fail();
        }
        catch (SecurityException e) {
            // empty catch block
        }
        this.service.logout(this.token);
        try {
            this.service.store(this.token, this.aWikitty);
            Assert.fail();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Ignore
    @Test
    public void testReaderRightOnWikitty() {
    }

    @Ignore
    @Test
    public void checkReaderRightOnExtension() {
        try {
            this.service.store(this.noRightsToken, this.aWikitty);
            Assert.fail((String)"an exception should have been raised");
        }
        catch (SecurityException e) {
            log.debug((Object)"creating a wikitty without rights", (Throwable)e);
        }
        try {
            this.service.restoreExtension(this.noRightsToken, this.extension.getId());
            Assert.fail((String)"an exception should have been raised");
        }
        catch (SecurityException e) {
            log.debug((Object)"creating a wikitty without rights", (Throwable)e);
        }
        try {
            this.service.restoreExtensionLastVersion(this.noRightsToken, this.extension.getName());
            Assert.fail((String)"an exception should have been raised");
        }
        catch (SecurityException e) {
            log.debug((Object)"creating a wikitty without rights", (Throwable)e);
        }
        try {
            this.service.store(this.readerToken, this.aWikitty);
            this.service.restoreExtension(this.readerToken, this.extension.getId());
            this.service.restoreExtensionLastVersion(this.readerToken, this.extension.getName());
        }
        catch (SecurityException e) {
            Assert.fail((String)"an exception has been raised");
        }
    }

    @Ignore
    @Test
    public void checkWriterRightOnExtension() {
        FieldType fieldType = new FieldType(FieldType.TYPE.STRING, 0, 1);
        this.service.restoreExtensionLastVersion(this.writerToken, this.extension.getName());
        this.extension.addField("new_field", fieldType);
        try {
            this.service.storeExtension(this.readerToken, this.extension);
            Assert.fail((String)"an exception should have been raised");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            this.service.storeExtension(this.writerToken, this.extension);
        }
        catch (SecurityException e) {
            Assert.fail((String)"an exception has been raised");
        }
    }

    @Ignore
    @Test
    public void checkAdminRightOnExtention() {
        Wikitty extensionAuthorisation = this.securityService.restoreExtensionAuthorisation(this.adminToken, this.extension);
        log.debug((Object)("initial rights " + extensionAuthorisation));
        WikittyAuthorisationHelper.clearReader((Wikitty)extensionAuthorisation);
        WikittyAuthorisationHelper.clearWriter((Wikitty)extensionAuthorisation);
        WikittyAuthorisationHelper.addWriter((Wikitty)extensionAuthorisation, (String)"ID1");
        WikittyAuthorisationHelper.setOwner((Wikitty)extensionAuthorisation, (String)"ID2");
        log.debug((Object)("will store rights " + extensionAuthorisation));
        this.service.store(this.adminToken, extensionAuthorisation);
        extensionAuthorisation = this.service.restore(this.adminToken, extensionAuthorisation.getId());
        log.debug((Object)("restored rights " + extensionAuthorisation));
        Assert.assertTrue((boolean)WikittyAuthorisationHelper.getReader((Wikitty)extensionAuthorisation).isEmpty());
        Assert.assertTrue((boolean)WikittyAuthorisationHelper.getWriter((Wikitty)extensionAuthorisation).contains("ID1"));
        Assert.assertEquals((long)1L, (long)WikittyAuthorisationHelper.getWriter((Wikitty)extensionAuthorisation).size());
        Assert.assertFalse((boolean)WikittyAuthorisationHelper.getAdmin((Wikitty)extensionAuthorisation).isEmpty());
        Assert.assertFalse((boolean)WikittyAuthorisationHelper.getOwner((Wikitty)extensionAuthorisation).equals("ID2"));
    }

    @Test
    public void checkOwnerRightOnExtention() {
    }
}

