/* *##%
 * Copyright (C) 2010 Code Lutin, Chatellier Eric
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.nuiton.wikitty;

import java.util.EventObject;
import java.util.Map;
import java.util.Set;

/**
 * Wikitty service event.
 * 
 * Contains :
 * <ul>
 *  <li>Wikitty service as source
 *  <li>ids : wikitty ids or extensions ids
 *  <li>ids & version : only for put : version of added wikitties
 *  <li>ids & extension : only for put : extension of added ids
 * </ul>
 * 
 * @author chatellier
 * @version $Revision: 120 $
 * 
 * Last update : $Date: 2010-06-11 12:36:03 +0200 (ven., 11 juin 2010) $
 * By : $Author: echatellier $
 */
public class WikittyServiceEvent extends EventObject {

    /** serialVersionUID. */
    private static final long serialVersionUID = 9017732163643700599L;

    /** Remote event (received from jgroup). */
    protected boolean remote;

    /**
     * Id managed by event.
     * 
     * Can be :
     * <ul>
     *  <li>wikitty ids (uuid)
     *  <li>extension ids (ex : toto[2.1])
     * </ul>
     */
    protected Set<String> ids;
    
    /**
     * Map between extensions set for each id.
     */
    protected Map<String, Set<String>> idExtensions;
    
    /**
     * Map between versions for each id.
     */
    protected Map<String, String> idVersions;

    /**
     * Constructor with source {@link WikittyService}.
     * 
     * @param source wikitty service
     */
    public WikittyServiceEvent(Object source) {
        super(source);
    }

    /**
     * To allow set transient source after deserialisation.
     * 
     * @param source source
     */
    public void setSource(Object source) {
        this.source = source;
    }

    /**
     * Is event remote.
     * 
     * @return remote event
     */
    public boolean isRemote() {
        return remote;
    }

    /**
     * Change remote event property.
     * 
     * @param remote remote
     */
    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    /**
     * Get ids.
     * 
     * @return ids or {@code null} if no ids is related to event
     */
    public Set<String> getIds() {
        return ids;
    }

    /**
     * Set ids.
     * 
     * @param ids ids to set
     */
    public void setIds(Set<String> ids) {
        this.ids = ids;
    }

    /**
     * Get id and extensions map.
     * 
     * @return map with extension set for each id or {@code null} if no ids is related to event
     */
    public Map<String, Set<String>> getIdExtensions() {
        return idExtensions;
    }

    /**
     * Change id and extensions map.
     * 
     * @param idExtensions id and extensions map
     */
    public void setIdExtensions(Map<String, Set<String>> idExtensions) {
        this.idExtensions = idExtensions;
    }
    
    /**
     * Get id and version map.
     * 
     * @return map with version for each id
     */
    public Map<String, String> getIdVersions() {
        return idVersions;
    }

    /**
     * Set id and version map.
     * 
     * @param idVersions id and versions
     */
    public void setIdVersions(Map<String, String> idVersions) {
        this.idVersions = idVersions;
    }

    @Override
    public String toString() {
        String toString = getClass().getName() + "[source=" + source +
        ", remote=" + remote + ", ids=" + ids + ", idExtensions=" + idExtensions +
        ", idVersions=" + idVersions + "]";
        return toString;
    }
}
