package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;


public  class WikittyAuthorisationHelper {

    /**
     * WikittyAuthorisationHelper :
     * utility class all provided methods are accessible the static way
     */

    private WikittyAuthorisationHelper() {// empty
}

    /**
     * getOwner :
     * @param wikitty 
     * @return String 
     */

    public static String getOwner(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_OWNER);
        return value;
}

    /**
     * setOwner :
     * @param wikitty 
     * @param Owner 
     * @return String 
     */

    public static String setOwner(Wikitty wikitty, String Owner) {
        String oldValue = getOwner(wikitty);
        wikitty.setField(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_OWNER, Owner);
        return oldValue;
}

    /**
     * getAdmin :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getAdmin(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, String.class);
        return result;
}

    /**
     * addAdmin :
     * @param wikitty 
     * @param element 
     */

    public static void addAdmin(Wikitty wikitty, String element) {
        wikitty.addToField(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, element);
}

    /**
     * removeAdmin :
     * @param wikitty 
     * @param element 
     */

    public static void removeAdmin(Wikitty wikitty, String element) {
        wikitty.removeFromField(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, element);
}

    /**
     * clearAdmin :
     * @param wikitty 
     */

    public static void clearAdmin(Wikitty wikitty) {
        wikitty.clearField(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN);
}

    /**
     * getWriter :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getWriter(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, String.class);
        return result;
}

    /**
     * addWriter :
     * @param wikitty 
     * @param element 
     */

    public static void addWriter(Wikitty wikitty, String element) {
        wikitty.addToField(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, element);
}

    /**
     * removeWriter :
     * @param wikitty 
     * @param element 
     */

    public static void removeWriter(Wikitty wikitty, String element) {
        wikitty.removeFromField(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, element);
}

    /**
     * clearWriter :
     * @param wikitty 
     */

    public static void clearWriter(Wikitty wikitty) {
        wikitty.clearField(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER);
}

    /**
     * getReader :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getReader(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, String.class);
        return result;
}

    /**
     * addReader :
     * @param wikitty 
     * @param element 
     */

    public static void addReader(Wikitty wikitty, String element) {
        wikitty.addToField(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, element);
}

    /**
     * removeReader :
     * @param wikitty 
     * @param element 
     */

    public static void removeReader(Wikitty wikitty, String element) {
        wikitty.removeFromField(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, element);
}

    /**
     * clearReader :
     * @param wikitty 
     */

    public static void clearReader(Wikitty wikitty) {
        wikitty.clearField(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER);
}

    /**
     * getParent :
     * @param wikitty 
     * @return String 
     */

    public static String getParent(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_PARENT);
        return value;
}

    /**
     * setParent :
     * @param wikitty 
     * @param parent 
     * @return String 
     */

    public static String setParent(Wikitty wikitty, String parent) {
        String oldValue = getParent(wikitty);
        wikitty.setField(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_PARENT, parent);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_OWNER);
            Object f2 = w2.getFieldAsObject(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_OWNER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN);
            Object f2 = w2.getFieldAsObject(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER);
            Object f2 = w2.getFieldAsObject(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER);
            Object f2 = w2.getFieldAsObject(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_PARENT);
            Object f2 = w2.getFieldAsObject(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_PARENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyAuthorisationAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}

    /**
     * addMetaExtension :
     * add WikittyAuthorisation meta-extension on given extension to the given wikitty
     * @param extension 
     * @param wikitty 
     */

    public static void addMetaExtension(WikittyExtension extension, Wikitty wikitty) {
        wikitty.addMetaExtension(WikittyAuthorisationAbstract.extensionWikittyAuthorisation, extension);
}

    /**
     * hasMetaExtension :
     * true if given wikitty has WikittyAuthorisation meta-extension on given extension
     * @param extension 
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasMetaExtension(WikittyExtension extension, Wikitty wikitty) {
        return wikitty.hasMetaExtension(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, extension.getName());
}

    /**
     * getMetaFieldName :
     * for extension 'Ext' and field 'f', return 'Ext:WikittyAuthorisation.f'
     * @param extension 
     * @param fieldName 
     * @return String 
     */

    public static String getMetaFieldName(WikittyExtension extension, String fieldName) {
        String metaFieldName = getMetaFieldName(extension.getName(), fieldName); 
        return metaFieldName;
}

    /**
     * getMetaFieldName :
     * for extension 'Ext' and field 'f', return 'Ext:WikittyAuthorisation.f'
     * @param extensionName 
     * @param fieldName 
     * @return String 
     */

    public static String getMetaFieldName(String extensionName, String fieldName) {
        String metaFieldName = WikittyUtil.getMetaFieldName("WikittyAuthorisation", extensionName, fieldName);
        return metaFieldName;
}

    /**
     * getOwner :
     * @param extensionName 
     * @param wikitty 
     * @return String 
     */

    public static String getOwner(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "Owner");
        String value = (String) wikitty.getFqField(fieldName);        
        return value;
}

    /**
     * setOwner :
     * @param extensionName 
     * @param wikitty 
     * @param Owner 
     * @return String 
     */

    public static String setOwner(String extensionName, Wikitty wikitty, String Owner) {
        String oldValue = getOwner(extensionName, wikitty);
        String fieldName = getMetaFieldName(extensionName, "Owner");
        wikitty.setFqField(fieldName, Owner);
        return oldValue;
}

    /**
     * getAdmin :
     * @param extensionName 
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getAdmin(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "Admin");
        Set<String> result = (Set<String>) wikitty.getFqField(fieldName);        
        return result;
}

    /**
     * addAdmin :
     * @param extensionName 
     * @param wikitty 
     * @param element 
     */

    public static void addAdmin(String extensionName, Wikitty wikitty, String element) {        
        String fieldName = getMetaFieldName(extensionName, "Admin");
        wikitty.addToField(fieldName, element);
}

    /**
     * removeAdmin :
     * @param extensionName 
     * @param wikitty 
     * @param element 
     */

    public static void removeAdmin(String extensionName, Wikitty wikitty, String element) {
        String fieldName = getMetaFieldName(extensionName, "Admin");
        wikitty.removeFromField(fieldName, element);
}

    /**
     * clearAdmin :
     * @param extensionName 
     * @param wikitty 
     */

    public static void clearAdmin(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "Admin");
        wikitty.clearField(fieldName);
}

    /**
     * getWriter :
     * @param extensionName 
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getWriter(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "Writer");
        Set<String> result = (Set<String>) wikitty.getFqField(fieldName);        
        return result;
}

    /**
     * addWriter :
     * @param extensionName 
     * @param wikitty 
     * @param element 
     */

    public static void addWriter(String extensionName, Wikitty wikitty, String element) {        
        String fieldName = getMetaFieldName(extensionName, "Writer");
        wikitty.addToField(fieldName, element);
}

    /**
     * removeWriter :
     * @param extensionName 
     * @param wikitty 
     * @param element 
     */

    public static void removeWriter(String extensionName, Wikitty wikitty, String element) {
        String fieldName = getMetaFieldName(extensionName, "Writer");
        wikitty.removeFromField(fieldName, element);
}

    /**
     * clearWriter :
     * @param extensionName 
     * @param wikitty 
     */

    public static void clearWriter(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "Writer");
        wikitty.clearField(fieldName);
}

    /**
     * getReader :
     * @param extensionName 
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getReader(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "Reader");
        Set<String> result = (Set<String>) wikitty.getFqField(fieldName);        
        return result;
}

    /**
     * addReader :
     * @param extensionName 
     * @param wikitty 
     * @param element 
     */

    public static void addReader(String extensionName, Wikitty wikitty, String element) {        
        String fieldName = getMetaFieldName(extensionName, "Reader");
        wikitty.addToField(fieldName, element);
}

    /**
     * removeReader :
     * @param extensionName 
     * @param wikitty 
     * @param element 
     */

    public static void removeReader(String extensionName, Wikitty wikitty, String element) {
        String fieldName = getMetaFieldName(extensionName, "Reader");
        wikitty.removeFromField(fieldName, element);
}

    /**
     * clearReader :
     * @param extensionName 
     * @param wikitty 
     */

    public static void clearReader(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "Reader");
        wikitty.clearField(fieldName);
}

    /**
     * getParent :
     * @param extensionName 
     * @param wikitty 
     * @return String 
     */

    public static String getParent(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "parent");
        String value = (String) wikitty.getFqField(fieldName);        
        return value;
}

    /**
     * setParent :
     * @param extensionName 
     * @param wikitty 
     * @param parent 
     * @return String 
     */

    public static String setParent(String extensionName, Wikitty wikitty, String parent) {
        String oldValue = getParent(extensionName, wikitty);
        String fieldName = getMetaFieldName(extensionName, "parent");
        wikitty.setFqField(fieldName, parent);
        return oldValue;
}


} //WikittyAuthorisationHelper
