package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;


public  abstract class SecurityTokenAbstract extends BusinessEntityWikitty implements SecurityToken {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionSecurityToken;
    /**
     * getUser :
     * @return String 
     */

    @Override
    public String getUser() {
        String value = SecurityTokenHelper.getUser(getWikitty());
        return value;
}

    /**
     * setUser :
     * @param user 
     */

    @Override
    public void setUser(String user) {
        String oldValue = getUser();
        SecurityTokenHelper.setUser(getWikitty(), user);
        getPropertyChangeSupport().firePropertyChange(SecurityToken.FIELD_SECURITYTOKEN_USER, oldValue, getUser());
}

    /**
     * SecurityTokenAbstract :
     */

    public SecurityTokenAbstract() {
        super();
}

    /**
     * SecurityTokenAbstract :
     * @param wikitty 
     */

    public SecurityTokenAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * SecurityTokenAbstract :
     * @param businessEntityWikitty 
     */

    public SecurityTokenAbstract(BusinessEntityWikitty businessEntityWikitty) {
        super(businessEntityWikitty.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionSecurityToken =
                new WikittyExtension(EXT_SECURITYTOKEN,
                                     "1.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "Wikitty user unique=true"));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionSecurityToken);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //SecurityTokenAbstract
