package org.nuiton.wikitty.search;

import java.io.Serializable;

/**
 * NotEquals operator is used to build restriction containing "element != value"
 * where element could be an Id, a String, a multimedia, a closed list, an
 * Integer, a Float or a Date. <br>
 * <br>
 * For example, use: RestrictionHelper.neq( myElement , "REF1234567890" )
 */
public class NotEquals extends BinaryOperator implements Serializable {

    // serialVersionUID is used for serialization.
    private static final long serialVersionUID = 1L;

    /**
     * Default constructor
     */
    public NotEquals() {
        super();
    }

    /**
     * Equality test based attributes values
     * 
     * @param other Value to compare
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NotEquals)) {
            return false;
        }

        final NotEquals notEquals = (NotEquals) other;

        return super.equals(notEquals);
    }

    public int hashCode() {
        int result = NotEquals.class.getName().hashCode();
        result = 29 * result + super.hashCode();
        return result;
    }

}