package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SecurityTokenHelper extends SecurityTokenImpl {

    private static final long serialVersionUID = 733790430L;


    /**
     * This class is not instanciable, it's just helper
     */
    private SecurityTokenHelper() {
    }


    static public void setUser(Wikitty w, String user) {
        w.setField(EXT_SECURITYTOKEN, "user", user);
    }

    static public String getUser(Wikitty w) {
        String result = w.getFieldAsString(EXT_SECURITYTOKEN, "user");
        return result;
    }


    /**
     * Check if wikitty has current extension
     */
    static public boolean isExtension(Wikitty w) {
        boolean result = w.hasExtension(EXT_SECURITYTOKEN);
        return result;
    }

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     */
    static public void addExtension(Wikitty w) {
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SECURITYTOKEN, FIELD_USER);
            Object f2 = w2.getFieldAsObject(EXT_SECURITYTOKEN, FIELD_USER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //SecurityTokenHelper
