/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.replication.model;

import java.util.Arrays;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.replication.TopiaReplicationOperation;
import org.nuiton.topia.replication.model.ReplicationNode;
import org.nuiton.topia.replication.model.ReplicationOperationPhase;

public class ReplicationOperationDef
implements Comparable<ReplicationOperationDef> {
    protected final ReplicationOperationPhase phase;
    protected final Class<? extends TopiaReplicationOperation> operationClass;
    protected final ReplicationNode node;
    protected final Object[] parameters;

    public ReplicationOperationDef(ReplicationOperationPhase phase, Class<? extends TopiaReplicationOperation> operation, ReplicationNode node, Object ... parameters) {
        this.operationClass = operation;
        this.phase = phase;
        this.node = node;
        this.parameters = parameters;
    }

    public ReplicationNode getNode() {
        return this.node;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public Class<? extends TopiaReplicationOperation> getOperationClass() {
        return this.operationClass;
    }

    public ReplicationOperationPhase getPhase() {
        return this.phase;
    }

    public TopiaEntityEnum getContract() {
        return this.node.getContract();
    }

    public Class<? extends TopiaEntity> getEntityType() {
        return this.node.getEntityType();
    }

    public String toString() {
        return " <" + this.operationClass.getSimpleName() + " on " + String.valueOf(this.node) + (String)(this.parameters.length == 0 ? "" : ", params:" + Arrays.toString(this.parameters)) + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationOperationDef that = (ReplicationOperationDef)o;
        if (!this.node.equals(that.node)) {
            return false;
        }
        if (!this.operationClass.equals(that.operationClass)) {
            return false;
        }
        return this.phase == that.phase;
    }

    public int hashCode() {
        int result = this.phase.hashCode();
        result = 31 * result + this.operationClass.hashCode();
        result = 31 * result + this.node.hashCode();
        return result;
    }

    @Override
    public int compareTo(ReplicationOperationDef o) {
        int result = this.getPhase().compareTo(o.getPhase());
        return result;
    }
}

