/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.util;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.ArrayUtils;
import org.nuiton.topia.persistence.TopiaEntity;

public class TopiaEntityRef
implements Comparable<TopiaEntityRef> {
    public static final String SEPARATOR = "/";
    protected TopiaEntity root;
    protected TopiaEntity ref;
    protected String accessorExpression;
    protected TopiaEntity[] path;

    public TopiaEntityRef(TopiaEntity root, TopiaEntity ref, String accessorExpression, TopiaEntity[] path) {
        Preconditions.checkNotNull((Object)ref);
        this.root = root;
        this.ref = ref;
        this.accessorExpression = accessorExpression;
        this.path = (TopiaEntity[])ArrayUtils.clone((Object[])path);
    }

    public TopiaEntity getRoot() {
        return this.root;
    }

    public TopiaEntity getRef() {
        return this.ref;
    }

    public String getAccessorExpression() {
        return this.accessorExpression;
    }

    public TopiaEntity[] getPath() {
        return this.path;
    }

    public TopiaEntity getInvoker() {
        return this.path == null || this.path.length < 2 ? null : this.path[this.path.length - 2];
    }

    public String getInvokerProperty() {
        if (this.path == null || this.path.length < 2) {
            return null;
        }
        int pos = this.path.length - 1;
        String[] expressions = this.accessorExpression.split(SEPARATOR);
        String invokerProperty = expressions[pos];
        return invokerProperty;
    }

    public String toString() {
        return super.toString() + " : " + this.accessorExpression;
    }

    @Override
    public int compareTo(TopiaEntityRef o) {
        return this.ref.getTopiaId().compareTo(o.getRef().getTopiaId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopiaEntityRef that = (TopiaEntityRef)o;
        return this.ref.equals(that.ref);
    }

    public int hashCode() {
        return this.ref.hashCode();
    }
}

