package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper.TopiaTestEntityEnum;
import org.nuiton.topia.persistence.TopiaEntity;

@Generated(value = "org.nuiton.topia.generator.EntityDAOTransformer", date = "Mon Sep 25 10:14:42 CEST 2017")
public abstract class EmployeDAOAbstract<E extends Employe> extends PersonneDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Employe.class;
    }

    @Override
    public TopiaTestEntityEnum getTopiaEntityEnum() {
        return TopiaTestEntityEnum.Employe;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Department> list = getContext()
                                                    .getDAO(Department.class)
                                                    .findAllByProperties(Department.PROPERTY_LEADER, entity);
                                            for (Department item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getLeader())) {
                                                    item.setLeader(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findBySalary(int v) throws TopiaException {
        E result = findByProperty(Employe.PROPERTY_SALARY, v);
        return result;
    }

    public List<E> findAllBySalary(int v) throws TopiaException {
        List<E> result = findAllByProperty(Employe.PROPERTY_SALARY, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Department.class) {
            DepartmentDAO dao = (DepartmentDAO)
                getContext().getDAO(Department.class);
            tmp = dao.findAllByLeader(entity);
            result.addAll(tmp);
        }

        if (type == Company.class) {
            CompanyDAO dao = (CompanyDAO)
                getContext().getDAO(Company.class);
            tmp = dao.findAllContainsEmploye(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(Department.class, entity);
        if (!list.isEmpty()) {
            result.put(Department.class, list);
        }

        list = findUsages(Company.class, entity);
        if (!list.isEmpty()) {
            result.put(Company.class, list);
        }

        return result;
    }

} //EmployeDAOAbstract<E extends Employe>
