/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor;

import com.opensymphony.xwork2.ActionContext;
import info.monitorenter.cpdetector.io.ASCIIDetector;
import info.monitorenter.cpdetector.io.ByteOrderMarkDetector;
import info.monitorenter.cpdetector.io.CodepageDetectorProxy;
import info.monitorenter.cpdetector.io.ICodepageDetector;
import info.monitorenter.cpdetector.io.JChardetFacade;
import info.monitorenter.cpdetector.io.ParsingDetector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.sax.BodyContentHandler;
import org.nuiton.scmwebeditor.ScmSession;
import org.nuiton.scmwebeditor.SvnConnection;
import org.nuiton.web.struts2.BaseAction;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ScmWebEditorBaseAction
extends BaseAction {
    public static final String AUTH_ERROR = "authError";
    public static final String ERROR_PATH = "errorPath";
    protected Map<String, Object> session;
    private static final long serialVersionUID = 1L;
    protected static final String CONTEXT_ACTION_KEY = "action";
    private static final Log log = LogFactory.getLog(ScmWebEditorBaseAction.class);
    protected static final String PARAMETER_ADDRESS = "address";
    protected static final String PARAMETER_SCM_EDITOR_URL = "scmEditorUrl";
    protected static final String PARAMETER_PROJECT_URL = "projectUrl";
    protected static final String PARAMETER_FILE_NAME = "file_name";
    protected static final String PARAMETER_LANG = "lang";
    protected static final String PARAMETER_DEFAULT_LANG = "defaultLang";
    protected static final String PARAMETER_FORMAT = "format";
    protected static final String PARAMETER_USERNAME = "username";
    protected static final String PARAMETER_PW = "pw";
    protected static final String PARAMETER_MYTEXT = "Mytext";
    protected static final String PARAMETER_ORIG_TEXT = "Orig_text";
    protected static final String PARAMETER_COMMIT_MESSAGE = "Commit_message";
    protected static final String PARAMETER_TEXT = "text";
    protected static final String ATTRIBUTE_REDIRECTION_URL = "Redirection_url";
    private static final String ATTRIBUTE_SVN_SESSION = "myInfo";
    protected static final String ATTRIBUTE_ORIG_TEXT = "OrigText";
    protected static final String ATTRIBUTE_INVALIDATE_MAX_TIME = "InvalidateMaxTime";
    protected static final String ATTRIBUTE_LOGIN = "Login";
    protected static final String ATTRIBUTE_IS_LOGIN = "IsLogin";
    protected static final String ATTRIBUTE_BAD_LOGIN = "badLogin";
    protected static final String ATTRIBUTE_PROJECT_URL = "projectUrl";
    protected static final String ATTRIBUTE_SCM_EDITOR_URI = "scmEditorUri";
    protected static final String ATTRIBUTE_PREVIEW_SERVLET_URL = "previewServletUrl";
    protected static final String ATTRIBUTE_FILESEARCH_SERVLET_URL = "searchServletUrl";
    protected static final String ATTRIBUTE_REDIRECT_URL = "Redirect_url";
    protected static final String ATTRIBUTE_PRIVATE_SERVLET_URI = "privateServletUri";
    protected static final String PROPERTIESFILES = "scmwebeditor.properties";
    protected static final String EDITABLESFILES = "editableFiles";
    protected static CodepageDetectorProxy detector;

    protected CodepageDetectorProxy getCodepageDetector() {
        if (detector == null) {
            detector = CodepageDetectorProxy.getInstance();
            detector.add((ICodepageDetector)new ByteOrderMarkDetector());
            detector.add((ICodepageDetector)new ParsingDetector(true));
            detector.add((ICodepageDetector)JChardetFacade.getInstance());
            detector.add(ASCIIDetector.getInstance());
        }
        return detector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertToUnicode(File ... files) {
        CodepageDetectorProxy myDetector = this.getCodepageDetector();
        for (File file : files) {
            try {
                Charset charset = myDetector.detectCodepage(file.toURI().toURL());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Charset for " + file.getAbsolutePath() + " is " + charset));
                }
                if (charset != null && !charset.name().equalsIgnoreCase("UTF-8")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Convert " + file.getAbsolutePath() + " to unicode"));
                    }
                    File tmpFile = File.createTempFile(file.getName(), ".copy");
                    tmpFile.deleteOnExit();
                    FileInputStream is = new FileInputStream(file);
                    FileOutputStream os = new FileOutputStream(tmpFile);
                    try {
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                    }
                    finally {
                        ((InputStream)is).close();
                        ((OutputStream)os).close();
                    }
                    is = new FileInputStream(tmpFile);
                    os = new FileOutputStream(file);
                    InputStreamReader ir = new InputStreamReader((InputStream)is, charset);
                    OutputStreamWriter ow = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                    try {
                        IOUtils.copy((Reader)ir, (Writer)ow);
                        continue;
                    }
                    finally {
                        ((Reader)ir).close();
                        ((Writer)ow).close();
                        ((InputStream)is).close();
                        ((OutputStream)os).close();
                    }
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("File " + file.getAbsolutePath() + " already in unicode : skip"));
            }
            catch (MalformedURLException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't convert file in unicode", (Throwable)e);
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't convert file in unicode", (Throwable)e);
            }
        }
    }

    public void checkout(SvnConnection svnSess, File checkoutdir, String numVersion) throws SVNException {
        SVNUpdateClient upclient = new SVNUpdateClient((ISVNRepositoryPool)svnSess.getManager(), (ISVNOptions)svnSess.getSvnOption());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Do Checkout of " + svnSess.getRemoteUrl()));
        }
        try {
            upclient.doCheckout(svnSess.getRemoteUrl(), checkoutdir, SVNRevision.create((long)Long.parseLong(numVersion)), SVNRevision.create((long)Long.parseLong(numVersion)), SVNDepth.FILES, false);
        }
        catch (NumberFormatException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"The number version is not valid.");
            }
            upclient.doCheckout(svnSess.getRemoteUrl(), checkoutdir, SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.FILES, false);
        }
    }

    public void checkout(SvnConnection svnSess, File checkoutdir) throws SVNException {
        SVNUpdateClient upclient = new SVNUpdateClient((ISVNRepositoryPool)svnSess.getManager(), (ISVNOptions)svnSess.getSvnOption());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Do Checkout of " + svnSess.getRemoteUrl()));
        }
        upclient.doCheckout(svnSess.getRemoteUrl(), checkoutdir, SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.FILES, false);
    }

    public String getHeadRevision(String address, String login, String password) throws SVNException, IllegalArgumentException {
        String lastRevision;
        block6: {
            SvnConnection svnConn = new SvnConnection(address);
            String url = svnConn.getSvnPath();
            String file = svnConn.getFileName();
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)url));
            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)login, (String)password);
            repository.setAuthenticationManager(authManager);
            SVNNodeKind nodeKind = repository.checkPath(file, -1L);
            if (nodeKind == SVNNodeKind.NONE) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("There is no entry at '" + url + "'."));
                }
                throw new IllegalArgumentException("There is no entry at '" + url + "'.");
            }
            if (nodeKind == SVNNodeKind.DIR) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("The entry at '" + url + "' is a file while a directory was expected."));
                }
                throw new IllegalArgumentException("The entry at '" + url + "' is a file while a directory was expected.");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SVNProperties fileProperties = new SVNProperties();
            repository.getFile(file, -1L, fileProperties, (OutputStream)baos);
            fileProperties.getStringValue("svn:entry:revision");
            lastRevision = baos.toString();
            try {
                baos.close();
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)"Can't close stream", (Throwable)e);
            }
        }
        return lastRevision;
    }

    public String getHeadNumberRevision(String address, String login, String password) throws SVNException {
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)login, (String)password);
        DefaultSVNOptions svnOption = new DefaultSVNOptions();
        svnOption.setPropertyValue("svn:eol-style", "LF");
        SVNWCClient wcClient = new SVNWCClient(authManager, (ISVNOptions)svnOption);
        SVNInfo info = wcClient.doInfo(SVNURL.parseURIEncoded((String)address), SVNRevision.HEAD, SVNRevision.HEAD);
        String headRevision = info.getRevision().toString();
        return headRevision;
    }

    public String getHeadcommiter(String address, String login, String password) throws SVNException {
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)login, (String)password);
        DefaultSVNOptions svnOption = new DefaultSVNOptions();
        svnOption.setPropertyValue("svn:eol-style", "LF");
        SVNWCClient wcClient = new SVNWCClient(authManager, (ISVNOptions)svnOption);
        SVNInfo info = wcClient.doInfo(SVNURL.parseURIEncoded((String)address), SVNRevision.HEAD, SVNRevision.HEAD);
        String headAuthor = info.getAuthor();
        return headAuthor;
    }

    public void delTempDirectory(File checkoutdir) {
        block2: {
            try {
                FileUtils.deleteDirectory((File)checkoutdir);
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't delete temp directory");
            }
        }
    }

    protected SvnConnection getSvnSession(HttpSession httpSession) {
        SvnConnection svnSess = (SvnConnection)httpSession.getAttribute(ATTRIBUTE_SVN_SESSION);
        return svnSess;
    }

    protected void setSvnSession(HttpSession httpSession, SvnConnection svnSess) {
        httpSession.setAttribute(ATTRIBUTE_SVN_SESSION, (Object)svnSess);
    }

    protected File getTempDir(HttpSession httpSession) {
        File tmp_dir = this.getSvnSession(httpSession).getCheckoutdir();
        return tmp_dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMimeType(File file) throws IOException, SAXException, TikaException {
        FileInputStream is = new FileInputStream(file);
        String result = null;
        try {
            BodyContentHandler contenthandler = new BodyContentHandler();
            Metadata metadata = new Metadata();
            metadata.set("resourceName", file.getName());
            AutoDetectParser parser = new AutoDetectParser();
            parser.parse((InputStream)is, (ContentHandler)contenthandler, metadata);
            result = metadata.get("Content-Type");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mine type of " + file.getName() + " is : " + result));
            }
        }
        catch (SAXException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't get MimeType, parsing error", (Throwable)e);
            }
        }
        catch (TikaException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't get MimeType, tika error", (Throwable)e);
            }
        }
        finally {
            ((InputStream)is).close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMimeType(String content, String filename) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());
        String result = null;
        try {
            BodyContentHandler contenthandler = new BodyContentHandler();
            Metadata metadata = new Metadata();
            metadata.set("resourceName", filename);
            AutoDetectParser parser = new AutoDetectParser();
            parser.parse((InputStream)is, (ContentHandler)contenthandler, metadata);
            result = metadata.get("Content-Type");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mine type of " + filename + " is : " + result));
            }
        }
        catch (SAXException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't get MimeType, parsing error", (Throwable)e);
            }
        }
        catch (TikaException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't get MimeType, tika error", (Throwable)e);
            }
        }
        finally {
            ((InputStream)is).close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getMimeTypes(String content, String filename) throws IOException, SAXException, TikaException {
        ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());
        try {
            BodyContentHandler contenthandler = new BodyContentHandler();
            Metadata metadata = new Metadata();
            metadata.set("resourceName", filename);
            AutoDetectParser parser = new AutoDetectParser();
            parser.parse((InputStream)is, (ContentHandler)contenthandler, metadata);
            String[] result = metadata.getValues("Content-Type");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mine type of " + filename + " is : " + result));
            }
            String[] stringArray = result;
            return stringArray;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String file) throws IOException {
        Properties properties = new Properties();
        FileInputStream input = new FileInputStream(file);
        try {
            properties.load(input);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            input.close();
        }
    }

    public static Properties loadProperties(InputStream inStream) throws IOException, NullPointerException {
        Properties properties = new Properties();
        properties.load(inStream);
        return properties;
    }

    public ScmSession getScmSession() {
        ScmSession scmSession;
        this.session = ActionContext.getContext().getSession();
        Object obj = this.session.get("ScmSession");
        if (obj == null) {
            scmSession = new ScmSession();
            this.session.put("ScmSession", scmSession);
        } else {
            scmSession = (ScmSession)obj;
        }
        return scmSession;
    }

    public String getUsername(String url) {
        return this.getScmSession().getUsername(url);
    }

    public String getPassword(String url) {
        return this.getScmSession().getPassword(url);
    }
}

