/*
 * #%L
 * ScmWebEditor
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.scmwebeditor.actions;

import com.jgeppert.struts2.jquery.tree.result.TreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.scmwebeditor.ScmWebEditorBaseAction;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;


public class SearchAction extends ScmWebEditorBaseAction {

    private static final long serialVersionUID = 4432027215087932750L;

    private static final Log log = LogFactory.getLog(SearchAction.class);

    protected String address;

    protected List<String> files;

    protected Map<String, String> directories;

    protected String username;

    protected String pw;

    protected String error;

    protected int numberOfFile;

    protected String info;

    protected String list;

    protected List<TreeNode> nodes = new ArrayList<TreeNode>();

    protected String id = "";

    public String getError() {
        return error;
    }

    public String getList() {
        return list;
    }

    public void setList(String list) {
        this.list = list;
    }

    public List<String> getFiles() {
        return files;
    }

    public Map<String, String> getDirectories() {
        return directories;
    }

    public String getInfo() {
        return info;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPw() {
        return pw;
    }

    public void setPw(String pw) {
        this.pw = pw;
    }

    public int getNumberOfFile() {
        return numberOfFile;
    }

    public String search() {

        if (log.isDebugEnabled()) {
            log.debug("Enter in search action");
        }


        DAVRepositoryFactory.setup();

        String url;


        String name = "anonymous";
        String password = "anonymous";

        if (username != null && pw != null) {
            name = username;
            password = pw;
        }


        if (address.endsWith("/")) {
            address = address.substring(0, address.length() - 1);
        }


        SVNRepository repository;
        ISVNAuthenticationManager authManager;


        if (id.equals("")) {

            try {
                if (log.isDebugEnabled()) {
                    log.debug("Address svn : " + address);
                }

                repository = SVNRepositoryFactory.create(SVNURL.parseURIDecoded(address));
                authManager = SVNWCUtil.createDefaultAuthenticationManager(name, password);
                repository.setAuthenticationManager(authManager);

                repository.testConnection();

            } catch (SVNAuthenticationException e) {
                if (log.isErrorEnabled()) {
                    log.error("Can't access to the repository : Auth Problem", e);
                }
                return "authError";
            } catch (SVNException e) {
                if (log.isErrorEnabled()) {
                    log.error("Can't access to the repository", e);
                }
                error = "Can't access to the repository";
            }

            return "root";
        } else if (id.equals("0")) {
            url = address;
        } else {
            url = id;
            address = id;
        }


        try {

            repository = SVNRepositoryFactory.create(SVNURL.parseURIDecoded(url));
            authManager = SVNWCUtil.createDefaultAuthenticationManager(name, password);
            repository.setAuthenticationManager(authManager);

            if (log.isDebugEnabled()) {
                log.debug("Repository Root: " + repository.getRepositoryRoot(true));
                log.debug("Repository UUID: " + repository.getRepositoryUUID(true));
            }

            SVNNodeKind nodeKind = repository.checkPath("", -1);
            if (nodeKind == SVNNodeKind.NONE) {
                if (log.isWarnEnabled()) {
                    log.warn("There is no entry at '" + url + "'.");
                }
                error = "There is no entry at '" + url + "'.";
                return SUCCESS;
            } else if (nodeKind == SVNNodeKind.FILE) {
                if (log.isDebugEnabled()) {
                    log.debug("The entry at '" + url + "' is a file.");
                }
                TreeNode node = new TreeNode();
                node.setId(url);
                node.setTitle(url.substring(url.lastIndexOf("/") + 1));
                node.setState(TreeNode.NODE_STATE_LEAF);
                node.setIcon("ui-icon-document");
                nodes.add(node);
                return SUCCESS;
            }
            numberOfFile = 0;
            listEntries(repository, "");
            if (log.isDebugEnabled()) {
                log.debug("Number of file : " + files.size());
            }


            for (String file : files) {
                TreeNode node = new TreeNode();
                node.setId(file);
                node.setTitle(file.substring(file.lastIndexOf("/") + 1));
                node.setState(TreeNode.NODE_STATE_LEAF);
                node.setIcon("ui-icon-document");
                nodes.add(node);
            }


            Iterator<Entry<String, String>> iter1 = directories.entrySet().iterator();
            while (iter1.hasNext()) {
                Map.Entry<String, String> ent = (Map.Entry<String, String>) iter1.next();

                String value = ent.getValue();

                TreeNode node = new TreeNode();
                node.setId(value);
                node.setTitle(value.substring(value.lastIndexOf("/")));
                nodes.add(node);


                //Traitement
            }


        } catch (SVNAuthenticationException authexep) {
            if (log.isErrorEnabled()) {
                log.error("Can't access to the repository : Auth Problem");
            }
            return "authError";
        } catch (SVNException svne) {
            if (log.isErrorEnabled()) {
                log.error("Can't access to the repository");
            }
            error = "Can't access to the repository";
        }

        if (log.isDebugEnabled()) {
            log.debug("Search success");
        }

        return SUCCESS;
    }


    public void listEntries(SVNRepository repository, String path) {

        files = new LinkedList<String>();
        directories = new HashMap<String, String>();

        Collection<?> entries = null;
        try {
            entries = repository.getDir(path, -1, null, (Collection<?>) null);
        } catch (SVNException e) {
            if (log.isErrorEnabled()) {
                log.error("Can not reach the repository", e);
            }
        }
        Iterator<?> iterator = entries.iterator();


        while (iterator.hasNext()) {
            SVNDirEntry entry = (SVNDirEntry) iterator.next();
            if (log.isDebugEnabled()) {
                log.debug("/" + (path.equals("") ? "" : path + "/") + entry.getName() + "\n");
            }
            String fichier = address + "/" + (path.equals("") ? "" : path + "/") + entry.getName();


            if (entry.getKind() == SVNNodeKind.DIR) {
                directories.put(getAddressUnique(fichier), fichier);

                //listEntries(repository, (path.equals("")) ? entry.getName() : path + "/" + entry.getName());
            } else {
                // On ajoute dans la liste files seulement les fichiers et pas les répertoires
                files.add(fichier);
            }
        }


    }


    public String getJSON() {
        return search();
    }

    public List<TreeNode> getNodes() {
        return nodes;
    }

    public void setId(String id) {
        this.id = id;
    }


    public String getAddressUnique(String leFichier) {
        String result = leFichier.replaceAll("/|:", "");
        if (log.isDebugEnabled()) {
            log.debug("Result of getAddressUnique : " + result);
        }
        return result;
    }


    public static String replaceLast(String string, String toReplace, String replacement) {
        int pos = string.lastIndexOf(toReplace);
        if (pos > -1) {
            return string.substring(0, pos)
                   + replacement
                   + string.substring(pos + toReplace.length(), string.length());
        } else {
            return string;
        }
    }


}
