/*
 * #%L
 * ScmWebEditor
 * 
 * $Id: ScmUrlResolverMavenSiteXmlImpl.java 248 2011-08-26 15:09:03Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/scmwebeditor/tags/scmwebeditor-0.3/src/main/java/org/nuiton/scmwebeditor/urlResolver/impl/ScmUrlResolverMavenSiteXmlImpl.java $
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.scmwebeditor.urlResolver.impl;

import org.apache.commons.lang.StringUtils;
import org.nuiton.scmwebeditor.urlResolver.ScmUrlResolver;

import java.io.IOException;
import java.net.URL;
import java.util.Map;

public class ScmUrlResolverMavenSiteXmlImpl implements ScmUrlResolver {

    public static final String MAVEN_SITE_XML_NAME = "maven-site.xml";

    public static final String PARAMETER_LOCALE = "svnlocale";

    public static final String PARAMETER_SVN_ROOT = "svnroot";


    @Override
    public String getLayoutName() {
        return MAVEN_SITE_XML_NAME;
    }

    @Override
    public URL resolv(Map<String, String> parameters) throws IOException, IllegalArgumentException {
        String local = parameters.get(PARAMETER_LOCALE);
        String svnRoot = parameters.get(PARAMETER_SVN_ROOT);

        if (StringUtils.isEmpty(svnRoot) || StringUtils.isEmpty(local)) {
            throw new IllegalArgumentException(
                    "Layout " + MAVEN_SITE_XML_NAME + " requires three parameters '" +
                    PARAMETER_LOCALE + "', '" + PARAMETER_SVN_ROOT + "'");
        }

        String result;

        result = svnRoot + "/src/site/site_" + local + ".xml";


        return new URL(result);
    }

}
