/*
 * #%L
 * ScmWebEditor
 * 
 * $Id: UploadAction.java 248 2011-08-26 15:09:03Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/scmwebeditor/tags/scmwebeditor-0.3/src/main/java/org/nuiton/scmwebeditor/actions/UploadAction.java $
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.scmwebeditor.actions;

import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.nuiton.scmwebeditor.ScmWebEditorBaseAction;
import org.nuiton.scmwebeditor.SvnConnection;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;

public class UploadAction extends ScmWebEditorBaseAction implements ServletRequestAware {

    private static final long serialVersionUID = 4244339447567114412L;

    private static final Log log = LogFactory.getLog(UploadAction.class);

    public static final String REDIRECT = "redirect";

    protected File upload;

    protected String uploadFileName;

    protected String uploadContentType;

    protected String username;

    protected String pw;

    protected String svnPath;

    protected String address;

    protected String svnRoot;

    protected String fileRoot;

    protected boolean badLogin;

    protected boolean error;

    protected transient HttpServletRequest request;

    public String getSvnPath() {
        return svnPath;
    }

    public void setSvnPath(String svnPath) {
        this.svnPath = svnPath;
    }

    public File getUpload() {
        return upload;
    }

    public void setUpload(File upload) {
        this.upload = upload;
    }

    public String getUploadContentType() {
        return uploadContentType;
    }

    public void setUploadContentType(String uploadContentType) {
        this.uploadContentType = uploadContentType;
    }

    public String getUploadFileName() {
        return uploadFileName;
    }

    public void setUploadFileName(String uploadFileName) {
        this.uploadFileName = uploadFileName;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPw() {
        return pw;
    }

    public void setPw(String pw) {
        this.pw = pw;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return address;
    }

    public boolean isBadLogin() {
        return badLogin;
    }

    public boolean isError() {
        return error;
    }

    public String getSvnRoot() {
        return svnRoot;
    }

    public String getFileRoot() {
        return fileRoot;
    }

    public String execute() {

        SvnConnection svnConnection = new SvnConnection(address);
        svnRoot = svnConnection.getSvnRoot();

        fileRoot = svnConnection.getSvnPath();

        if (svnRoot == null) {
            svnRoot = fileRoot;
        }


        SvnConnection svnConn;

        try {
            svnConn = new SvnConnection(address);
        } catch (StringIndexOutOfBoundsException e) {
            if (log.isErrorEnabled()) {
                log.error("error when creating SvnSession in UploadAction", e);
            }
            error = true;
            return ERROR;
        }


        //Si le repo n'est pas protege en ecriture on recupere sont UUID
        String repositoryUUID = svnConn.getUUID();
        if (repositoryUUID == null) {
            repositoryUUID = address;
        }


        if (username == null && pw == null) {
            if (getScmSession().getUsername(repositoryUUID) != null && getScmSession().getPassword(repositoryUUID) != null) {
                //On recupère les identifiants en session
                username = getScmSession().getUsername(repositoryUUID);
                pw = getScmSession().getPassword(repositoryUUID);
            } else {
                username = null;
                pw = null;
            }
        } else {
            getScmSession().addScmUser(repositoryUUID, username, pw);
        }


        svnConn.updateAuthentication(username, pw);

        try {
            svnConn.testConnection();
        } catch (SVNException e) {
            if (log.isDebugEnabled()) {
                log.debug("Test connection fail", e);
            }
            getScmSession().delScmUser(repositoryUUID);
            username = null;
            pw = null;
        }


        //Si il n'y a pas de fichier à uploader on retourne sur le formulaire d'upload
        if (upload == null) {
            return REDIRECT;
        }

        badLogin = false;
        error = false;

        if (log.isDebugEnabled()) {
            log.debug("FileName : " + uploadFileName);
            log.debug("ContentType : " + uploadContentType);
        }

        /*
        * Checkout process
        */
        SVNUpdateClient upclient = new SVNUpdateClient(svnConn.getManager(), svnConn.getSvnOption());

        File checkoutDir;
        try {
            svnConn.createCheckoutdir();
            checkoutDir = svnConn.getCheckoutdir();
        } catch (IOException e1) {
            if (log.isErrorEnabled()) {
                log.error("Can't create checkoutDir", e1);
            }
            error = true;
            return ERROR;
        }


        try {
            if (log.isDebugEnabled()) {
                log.debug("Do Checkout of " + svnRoot);
            }
            upclient.doCheckout(SVNURL.parseURIEncoded(svnRoot), checkoutDir,
                                SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.INFINITY, false);
        } catch (SVNAuthenticationException authexep) {

            // if svn authentication failed user is redirected on login page
            if (log.isDebugEnabled()) {
                log.debug("Private SCM on reading " + svnConn.getRemoteUrl());
            }
            //On supprime le repertoire temporaire
            delTempDirectory(checkoutDir);
            //redirect to a login page
            error = true;
            return ERROR;

        } catch (SVNException e) {
            //Suppression du repertoire temporaire
            delTempDirectory(checkoutDir);
            error = true;
            return ERROR;
        }


        //On test si le chemin se termine par un / si non, on l'ajoute
        if (!svnPath.endsWith("/")) {
            svnPath += "/";
        }


        //Copy file in checkourdir

        String checkoutPath = checkoutDir.getAbsolutePath();

        File file = new File(checkoutPath + svnPath.replace(svnRoot, ""), uploadFileName);

        try {
            FileUtils.copyFile(upload, file);
        } catch (IOException e) {
            error = true;
            if (log.isErrorEnabled()) {
                log.error("Can't copy the file to the checkout directory", e);
            }
            return ERROR;
        }


        //Commit process

        SVNClientManager manager = svnConn.getManager();


        try {

            if (log.isDebugEnabled()) {
                log.debug("leSvnPath : " + file.toString());
            }

            //On ajoute le repertoire
            manager.getWCClient().doAdd(file, false, false, false, SVNDepth.EMPTY, false, true);
            if (log.isDebugEnabled()) {
                log.debug("Add success !");
            }
            //On ajoute le fichier aux fichiers versionnés

        } catch (SVNException e) {
            if (log.isErrorEnabled()) {
                log.error("Erreur SVN Add", e);
            }
            error = true;
            //Suppression du repertoire temporaire
            delTempDirectory(checkoutDir);
            return ERROR;
        }

        File[] checkoutDirTab = new File[1];
        checkoutDirTab[0] = checkoutDir;

        try {
            manager.getCommitClient().doCommit(checkoutDirTab, false, "From scmwebeditor -- add the file : " + uploadFileName, null, null, false, true, SVNDepth.INFINITY);

            if (log.isDebugEnabled()) {
                log.debug("Commit success !");
            }

        } catch (SVNAuthenticationException authexep) {
            if (log.isErrorEnabled()) {
                log.error("authentification fail");
            }
            badLogin = true;
            //Suppression du repertoire temporaire
            delTempDirectory(checkoutDir);
            getScmSession().delScmUser(repositoryUUID);
            return LOGIN;
        } catch (SVNException e) {
            if (log.isErrorEnabled()) {
                log.error("Erreur SVN commit", e);
            }
            error = true;
            //Suppression du repertoire temporaire
            delTempDirectory(checkoutDir);
            return ERROR;
        }


        //Suppression du repertoire temporaire
        delTempDirectory(checkoutDir);

        if (log.isDebugEnabled()) {
            log.debug("File upload successful");
        }

        if (log.isInfoEnabled()) {
            log.info(username + " with IP " + request.getRemoteAddr() + " add the file " + getUploadFileName() + " on the repository.");
        }
        return SUCCESS;
    }

    @Override
    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }
}
