/*
 * #%L
 * ScmWebEditor
 * 
 * $Id: ScmWebEditorConfig.java 248 2011-08-26 15:09:03Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/scmwebeditor/tags/scmwebeditor-0.3/src/main/java/org/nuiton/scmwebeditor/ScmWebEditorConfig.java $
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.scmwebeditor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;

import java.util.List;

public class ScmWebEditorConfig {

    private static final Log log = LogFactory.getLog(ScmWebEditorConfig.class);


    protected static ApplicationConfig config;


    public static ApplicationConfig getConfig(String... args) {
        if (config == null) {
            synchronized (ScmWebEditorConfig.class) {
                if (config == null) {
                    config = new ApplicationConfig(ScmWebEditorConfigOption.CONFIG_FILE.getDefaultValue());
                    try {
                        config.parse(args);
                    } catch (ArgumentsParserException e) {
                        if (log.isErrorEnabled()) {
                            log.error("Error when parsing ApplicationConfig", e);
                        }
                    }
                }
            }
        }
        return config;
    }

    public static List<String> getEditableFiles() {
        return getEditableFiles(getConfig());
    }

    public static List<String> getEditableFiles(ApplicationConfig config) {
        return config.getOptionAsList(ScmWebEditorConfigOption.EDITABLESFILES.getKey()).getOption();
    }

    public static String getKey() {
        return getKey(getConfig());
    }

    public static String getKey(ApplicationConfig config) {
        return config.getOption(ScmWebEditorConfigOption.COOKIES_PRIVATE_KEY.getKey());
    }


}
