/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.actions;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.nuiton.scmwebeditor.ScmWebEditorBaseAction;
import org.nuiton.scmwebeditor.SvnConnection;
import org.nuiton.scmwebeditor.urlResolver.ScmUrlResolverEngine;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ScmWebEditorMainAction
extends ScmWebEditorBaseAction
implements ServletRequestAware {
    private static final long serialVersionUID = 8361035067228171624L;
    private static final Log log = LogFactory.getLog(ScmWebEditorMainAction.class);
    protected String address;
    protected String projectUrl;
    protected String format;
    protected String origText;
    protected String numRevision;
    protected String addressSvn;
    protected String username;
    protected String pw;
    protected HttpServletRequest request;
    protected String repositoryId;
    protected boolean fromLoginPage;

    public String getAddressSvn() {
        return this.addressSvn;
    }

    public void setAddressSvn(String addressSvn) {
        this.addressSvn = addressSvn;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPw() {
        return this.pw;
    }

    public void setPw(String pw) {
        this.pw = pw;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getOrigText() {
        return this.origText;
    }

    public String getProjectUrl() {
        return this.projectUrl;
    }

    public String getNumRevision() {
        return this.numRevision;
    }

    public void setProjectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
    }

    public void setFromLoginPage(boolean fromLoginPage) {
        this.fromLoginPage = fromLoginPage;
    }

    private boolean testParameters() {
        return this.address == null || this.address.length() == 0;
    }

    public String execute() {
        String mimeType;
        String originalText;
        block38: {
            Map map;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Connection to SCMWebEditor\n");
            }
            if (!this.fromLoginPage) {
                this.projectUrl = this.request.getHeader("referer");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("ProjectUrl= " + this.projectUrl));
            }
            if ((map = this.request.getParameterMap()).size() == 0 && this.testParameters()) {
                return "noParameter";
            }
            if (this.testParameters()) {
                HashMap<String, String> parameters = new HashMap<String, String>();
                for (Map.Entry n : map.entrySet()) {
                    String key = n.getKey().toString();
                    String[] values = (String[])n.getValue();
                    parameters.put(key, values[0].toString());
                }
                URL urlSvn = null;
                try {
                    urlSvn = ScmUrlResolverEngine.resolver(parameters);
                }
                catch (IOException e1) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"erreur", (Throwable)e1);
                    }
                    return "errorPath";
                }
                catch (IllegalArgumentException e1) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)e1.getMessage());
                    }
                    return "errorPath";
                }
                this.address = urlSvn.toString();
            }
            SvnConnection svnConn = null;
            try {
                svnConn = new SvnConnection(this.address);
            }
            catch (StringIndexOutOfBoundsException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Parameter is not valid ", (Throwable)e);
                }
                return "errorPath";
            }
            this.format = svnConn.getFileName().substring(svnConn.getFileName().lastIndexOf(".") + 1);
            originalText = "";
            String repositoryUUID = svnConn.getUUID();
            if (repositoryUUID == null) {
                repositoryUUID = this.address;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Login : " + this.username));
            }
            if (this.username == null && this.pw == null) {
                if (this.getScmSession().getUsername(repositoryUUID) != null && this.getScmSession().getPassword(repositoryUUID) != null) {
                    this.username = this.getScmSession().getUsername(repositoryUUID);
                    this.pw = this.getScmSession().getPassword(repositoryUUID);
                } else {
                    this.username = null;
                    this.pw = null;
                }
            } else {
                this.getScmSession().addScmUser(repositoryUUID, this.username, this.pw);
            }
            svnConn.updateAuthentication(this.username, this.pw);
            try {
                originalText = this.getHeadRevision(this.address, this.username, this.pw);
                this.numRevision = this.getHeadNumberRevision(this.address, this.username, this.pw);
            }
            catch (SVNAuthenticationException authexep) {
                this.request.setAttribute("address", (Object)this.address);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Auth Fail ", (Throwable)authexep);
                }
                this.getScmSession().delScmUser(repositoryUUID);
                return "login";
            }
            catch (SVNException e) {
                this.request.setAttribute("projectUrl", (Object)this.projectUrl);
                if (log.isErrorEnabled()) {
                    log.error((Object)"SVN error ", (Throwable)e);
                }
                return "errorPath";
            }
            catch (IllegalArgumentException e) {
                this.request.setAttribute("projectUrl", (Object)this.projectUrl);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SVN error debug", (Throwable)e);
                }
                return "errorPath";
            }
            mimeType = null;
            try {
                mimeType = this.getMimeType(originalText, svnConn.getFileName());
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block38;
                log.error((Object)"Can't get MimeType, problem when reading file", (Throwable)e);
            }
        }
        Properties properties = null;
        String[] editableFiles = null;
        try {
            properties = ScmWebEditorMainAction.loadProperties((String)"src/main/resources/scm.properties");
            if (log.isDebugEnabled()) {
                log.debug((Object)("editableFiles: " + properties.getProperty("editableFiles", "text")));
            }
            editableFiles = properties.getProperty("editableFiles", "text").split(",");
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't read properties file", (Throwable)e);
            }
            editableFiles = new String[]{"text"};
        }
        boolean editable = false;
        if (mimeType != null) {
            for (String fileType : editableFiles) {
                if (!mimeType.matches(".*" + fileType + ".*")) continue;
                editable = true;
            }
        }
        if (mimeType == null || !editable) {
            this.request.setAttribute("projectUrl", (Object)this.projectUrl);
            if (log.isErrorEnabled()) {
                log.error((Object)("Can't edit this file, mimetype : " + mimeType));
            }
            return "errorPath";
        }
        this.request.setAttribute("minetype", (Object)mimeType);
        this.origText = StringEscapeUtils.escapeHtml((String)originalText);
        this.request.setAttribute("projectUrl", (Object)this.projectUrl);
        if (log.isInfoEnabled()) {
            log.info((Object)("IP client : " + this.request.getRemoteAddr() + " , get file : " + this.address + ". File's mimetype : " + mimeType));
        }
        return "editPage";
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }
}

