/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SvnConnection {
    private static final Log log = LogFactory.getLog(SvnConnection.class);
    protected String addressSvn;
    protected String svnPath;
    protected String fileName;
    protected File checkoutdir;
    protected SVNURL remoteUrl;
    protected ISVNAuthenticationManager authManager;
    protected DefaultSVNOptions svnOption;
    protected SVNClientManager manager;
    protected String repositoryId;

    public SvnConnection(String address) throws StringIndexOutOfBoundsException {
        block2: {
            this.addressSvn = address;
            this.svnPath = address.substring(0, address.lastIndexOf("/"));
            this.fileName = address.substring(address.lastIndexOf("/") + 1);
            try {
                this.remoteUrl = SVNURL.parseURIEncoded((String)this.svnPath);
            }
            catch (SVNException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't parse svnPath", (Throwable)e);
            }
        }
        this.authManager = SVNWCUtil.createDefaultAuthenticationManager();
        this.svnOption = SVNWCUtil.createDefaultOptions((boolean)false);
        this.svnOption.setPropertyValue("svn:eol-style", "LF");
        this.manager = SVNClientManager.newInstance((ISVNOptions)this.svnOption, (ISVNAuthenticationManager)this.authManager);
    }

    public void updateAuthentication(String login, String password) {
        this.setAuthManager(SVNWCUtil.createDefaultAuthenticationManager((String)login, (String)password));
        this.setManager(SVNClientManager.newInstance((ISVNOptions)this.getSvnOption(), (ISVNAuthenticationManager)this.getAuthManager()));
    }

    public String getUUID() {
        String repositoryUUID = null;
        try {
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIDecoded((String)this.addressSvn));
            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager();
            repository.setAuthenticationManager(authManager);
            repositoryUUID = repository.getRepositoryUUID(true);
        }
        catch (SVNException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Can't get UUID");
            }
            return null;
        }
        return repositoryUUID;
    }

    public String getSvnRoot() {
        String repositoryRoot = null;
        try {
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIDecoded((String)this.addressSvn));
            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager();
            repository.setAuthenticationManager(authManager);
            repositoryRoot = repository.getRepositoryRoot(true).toString();
        }
        catch (SVNException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Can't get SvnRoot");
            }
            return null;
        }
        return repositoryRoot;
    }

    public void testConnection() throws SVNException {
        SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIDecoded((String)this.addressSvn));
        repository.setAuthenticationManager(this.authManager);
        repository.testConnection();
    }

    public boolean isDifferent(String text) throws IOException {
        File pathToFile = new File(this.checkoutdir, this.getFileName());
        SVNDiffClient diffClient = new SVNDiffClient((ISVNRepositoryPool)this.getManager(), (ISVNOptions)this.getSvnOption());
        FileUtils.writeStringToFile((File)pathToFile, (String)text);
        ByteArrayOutputStream diff = new ByteArrayOutputStream();
        try {
            diffClient.doDiff(pathToFile, SVNRevision.UNDEFINED, SVNRevision.WORKING, SVNRevision.HEAD, SVNDepth.INFINITY, true, (OutputStream)diff, null);
        }
        catch (SVNException e) {
            log.error((Object)"Diff fail", (Throwable)e);
            return false;
        }
        return diff.size() > 0;
    }

    public ByteArrayOutputStream getDiff(String text) throws IOException {
        File pathToFile = new File(this.checkoutdir, this.getFileName());
        SVNDiffClient diffClient = new SVNDiffClient((ISVNRepositoryPool)this.getManager(), (ISVNOptions)this.getSvnOption());
        FileUtils.writeStringToFile((File)pathToFile, (String)text);
        ByteArrayOutputStream diff = new ByteArrayOutputStream();
        try {
            diffClient.doDiff(pathToFile, SVNRevision.UNDEFINED, SVNRevision.WORKING, SVNRevision.HEAD, SVNDepth.INFINITY, true, (OutputStream)diff, null);
        }
        catch (SVNException e) {
            log.error((Object)"Diff fail", (Throwable)e);
        }
        return diff;
    }

    public ISVNAuthenticationManager getAuthManager() {
        return this.authManager;
    }

    public void setAuthManager(ISVNAuthenticationManager authManager) {
        this.authManager = authManager;
    }

    public File getCheckoutdir() {
        return this.checkoutdir;
    }

    public void createCheckoutdir() throws IOException {
        this.checkoutdir = FileUtil.createTempDirectory((String)"scm_", (String)"");
    }

    public void setCheckoutdir(File checkoutdir) {
        this.checkoutdir = checkoutdir;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public SVNClientManager getManager() {
        return this.manager;
    }

    public void setManager(SVNClientManager manager) {
        this.manager = manager;
    }

    public SVNURL getRemoteUrl() {
        return this.remoteUrl;
    }

    public void setRemoteUrl(SVNURL remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    public DefaultSVNOptions getSvnOption() {
        return this.svnOption;
    }

    public void setSvnOption(DefaultSVNOptions svnOption) {
        this.svnOption = svnOption;
    }

    public String getSvnPath() {
        return this.svnPath;
    }

    public void setSvnPath(String svnPath) {
        this.svnPath = svnPath;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }
}

