/*
 * #%L
 * ScmWebEditor
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.scmwebeditor.actions;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.nuiton.jrst.JRST;
import org.nuiton.scmwebeditor.ScmWebEditorBaseAction;
import org.nuiton.scmwebeditor.SvnConnection;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNCommitClient;



import com.opensymphony.xwork2.Action;



public class ScmWebEditorCommitAction extends ScmWebEditorBaseAction implements ServletRequestAware {
    /**
     * 
     */
    private static final long serialVersionUID = 6374273568146287730L;

    private static final Log log = LogFactory.getLog(ScmWebEditorCommitAction.class);
    
    protected String newText;
    protected String commitMessage;
    protected String origText;
    protected String username;
    protected String pw;
    protected String address;
    protected String lastText;
    protected String format;
    protected String projectUrl;
    protected String diff;
    protected String headCommiter;
    
    protected boolean force;
    
    protected String numRevision;
    
    




    protected HttpServletRequest request;
    
    public String getCommitMessage() {
        return commitMessage;
    }

    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    public String getNewText() {
        return newText;
    }

    public String getFormat() {
        return format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setNewText(String newText) {
        this.newText = newText;
    }
    
    public String getOrigText() {
        return origText;
    }

    public void setOrigText(String origText) {
        this.origText = origText;
    }
    
    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPw() {
        return pw;
    }

    public void setPw(String pw) {
        this.pw = pw;
    }
       
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    
    public String getLastText() {
        return lastText;
    }

    public void setLastText(String lastText) {
        this.lastText = lastText;
    }
    
    public String getProjectUrl() {
        return projectUrl;
    }


    public void setProjectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
    }   
    
    public void setForce(boolean force) {
        this.force = force;
    }
    
    
    public String getNumRevision() {
        return numRevision;
    }

    public void setNumRevision(String numRevision) {
        this.numRevision = numRevision;
    }
   
    public String getDiff() {
        return diff;
    }
    
    public String getHeadCommiter() {
        return headCommiter;
    }

    protected boolean isRstValid(String newText) {
        try {
            JRST.generate(JRST.TYPE_HTML, newText);
            if(log.isDebugEnabled()) {
                log.debug("RST generate success");
            }
            return true;
        } catch (Exception e) {
            if(log.isErrorEnabled()) {
                log.error("RST generate fail",e);
            }
            return false;
        }
        
        
    }
    
    
    
    public String execute() {
        
        if(!force)  {      
            if(format.equals("rst")) {
                if(!isRstValid(newText)) {
                    return "errorRst";
                }
            }       
        }
        
        
        SvnConnection svnConn = null;
        
        
        try {
            svnConn = new SvnConnection(address);
        } catch (StringIndexOutOfBoundsException e) {
            if(log.isDebugEnabled()) {
                log.debug("Parameter is not valid ",e);
            }
            return "error";  
        }
        
        
        String login = this.getUsername();
        String password = this.getPw();
        
        //Si le repo n'est pas protege en ecriture on recupere sont UUID
        String repositoryUUID = svnConn.getUUID();
        if (repositoryUUID==null) {
            repositoryUUID=address;
        }
        
        if( ( login==null || login.equals("") ) && ( password==null || password.equals("") ) ) {
            if(getScmSession().getUsername(repositoryUUID)!=null && getScmSession().getPassword(repositoryUUID)!=null) {
                //On recupère les identifiants en session
                login = getScmSession().getUsername(repositoryUUID);
                password = getScmSession().getPassword(repositoryUUID);
            }
            else {
                login = "anonymous";
                password = "anonymous";
            }
        }
        else {
            getScmSession().addScmUser(repositoryUUID, login , password);
        }
        

        svnConn.updateAuthentication( login, password);

        File checkoutdir = null;
        try {
            svnConn.createCheckoutdir();
        } catch (IOException e1) {
            if(log.isErrorEnabled()) {
                log.error("Can't create checkoutDir",e1);
            }
            return "error";
        }
        checkoutdir = svnConn.getCheckoutdir();
        
        
        // Avant le commit, il faut checkout le repertoire
        try {
            checkout(svnConn, checkoutdir);
        } catch (SVNAuthenticationException authexep) {
          request.setAttribute(PARAMETER_ADDRESS, address);
          
          // if svn authentication failed user is redirected on login page
          if(log.isDebugEnabled()) {
              log.debug("Private SCM on reading " + svnConn.getRemoteUrl());
          }
          //On supprime le repertoire temporaire
          delTempDirectory(checkoutdir);
          //redirect to a login page
          
          getScmSession().delScmUser(repositoryUUID);
          
          return Action.LOGIN;
          
        } catch (SVNException e) {
          if(log.isErrorEnabled()) {
              log.error("Can't checkout the file",e);
          }
          //Suppression du repertoire temporaire
          delTempDirectory(checkoutdir);
          return "errorPath";
        }


        File checkOutFile = new File(checkoutdir, svnConn.getFileName());
        
        
        lastText=newText;
        
        try {
            String originalText = FileUtils.readFileToString(checkOutFile);
            
            request.setAttribute("lastText", lastText);
            request.setAttribute(ATTRIBUTE_ORIG_TEXT, StringEscapeUtils.escapeHtml(originalText));

            

        } catch (FileNotFoundException ee) {
            /* fichier non trouve, on redirige vers BadFileRedirect.jsp
             * après avoir supprimé le repertoire temporaire
             */
            delTempDirectory(checkoutdir);

            return "error";
        } catch (IOException e) {
            log.error("Can't find the checkout file",e);
        }
     
        
        
        
        /*
         * Diff      
         */
        if(!force)  {
            try {
                
                if(svnConn.isDifferent(origText)) {
                    ByteArrayOutputStream differents = svnConn.getDiff(newText);
    
                    if(differents.size()>0) {
                        diff=differents.toString();
                        diff = diff.substring(diff.indexOf("@@"));
                        delTempDirectory(checkoutdir);
                        try {
                            headCommiter=getHeadcommiter(address, login, password);
                        } catch (SVNException e) {
                            log.error("Can't get head commiter",e);
                        }
                        return "fileModify";
                    }
                }
                
            } catch (IOException e) {
                if(log.isErrorEnabled()) {
                    log.error("Can't do diff on file, IO error",e);
                }
            }
        }
        
        
        
        /* 
         * Commit process
         */
//        File pathToFile = new File(checkoutdir, svnConn.getFileName());

        SVNCommitClient commitClient = new SVNCommitClient(svnConn.getManager(), svnConn.getSvnOption());
        
        File pathToFile = new File(checkoutdir, svnConn.getFileName());
        
        try {
            FileUtils.writeStringToFile(pathToFile, newText);
        } catch (IOException e1) {
            delTempDirectory(checkoutdir);
            return "error";
        }
        
        File[] tabFile = new File[1];
        tabFile[0] = pathToFile;

        
        
        try {
            if(log.isDebugEnabled()) {
                log.debug("Try to commit");
            }
            commitClient.doCommit(tabFile, false, "From scmwebeditor -- "+commitMessage, null, null, false, true, SVNDepth.FILES);
        } catch (SVNAuthenticationException authexep) {
            if(log.isErrorEnabled()) {
                log.error("AUTH FAIL");
            }

            // if authentication failed edition page is reload form user's relogin
            request.setAttribute("address", address);
            
            request.setAttribute(ATTRIBUTE_ORIG_TEXT, StringEscapeUtils.escapeHtml(newText));

            
            request.setAttribute(ATTRIBUTE_BAD_LOGIN, true);
            //Suppression du repertoire temporaire
            delTempDirectory(checkoutdir);
            
            //on supprime la valeur stocke en session
            getScmSession().delScmUser(repositoryUUID);
            return Action.LOGIN;
        } catch (SVNException e) {
            if(log.isErrorEnabled()) {
                log.error("SVN FAIL",e);
            }
            //Suppression du repertoire temporaire
            delTempDirectory(checkoutdir);
            return "error";
        }
       
        
        if (checkoutdir != null) {
            //Suppression du repertoire temporaire
            delTempDirectory(checkoutdir);
        }
        
        if(log.isDebugEnabled()) {
            log.debug("End of commit");
        }
        //Suppression du repertoire temporaire
        delTempDirectory(checkoutdir);
        
        if(log.isInfoEnabled()) {
            log.info(login + " with IP "+request.getRemoteAddr()+" commit the file "+address+" with message : "+commitMessage);
        }
        
        try {
            numRevision=getHeadNumberRevision(address, login, password);
        } catch (SVNException e) {
            numRevision=null;
        }
        
        return "success";
    }
    


    @Override
    public void setServletRequest(HttpServletRequest request) {
        this.request = request;        
    }

}
