/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.git;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.AuthenticationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.DeleteBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.RejectCommitException;
import org.eclipse.jgit.api.errors.UnmergedPathsException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.nuiton.scmwebeditor.api.OperationNotSupportedException;
import org.nuiton.scmwebeditor.api.RepositoryNotFoundException;
import org.nuiton.scmwebeditor.api.ScmConnection;
import org.nuiton.scmwebeditor.api.ScmFileManager;
import org.nuiton.scmwebeditor.api.ScmProvider;
import org.nuiton.scmwebeditor.api.SweInternalException;
import org.nuiton.scmwebeditor.api.dto.CreateBranchDto;
import org.nuiton.scmwebeditor.git.GitConnection;
import org.nuiton.scmwebeditor.git.GitFileManager;

public class GitProvider
implements ScmProvider {
    private static final Log log = LogFactory.getLog(GitProvider.class);
    protected String address;

    public boolean supportsBranches() {
        return true;
    }

    public List<String> listBranches(String address, String username, String password) throws OperationNotSupportedException {
        ArrayList<String> branches;
        block5: {
            if (username == null) {
                username = "anonymous";
            }
            if (password == null) {
                password = "anonymous";
            }
            branches = new ArrayList<String>();
            UsernamePasswordCredentialsProvider credentials = new UsernamePasswordCredentialsProvider(username, password);
            LsRemoteCommand lsRemote = new LsRemoteCommand(null);
            lsRemote.setRemote(address);
            lsRemote.setTags(false);
            lsRemote.setHeads(true);
            lsRemote.setCredentialsProvider((CredentialsProvider)credentials);
            try {
                Collection lsRemoteResult = lsRemote.call();
                branches = new ArrayList();
                for (Ref branch : lsRemoteResult) {
                    String name = branch.getName();
                    name = name.substring(name.indexOf("/") + 1);
                    name = name.substring(name.indexOf("/") + 1);
                    branches.add(name);
                }
            }
            catch (GitAPIException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)("The repository at address " + address + " could not be reached"), (Throwable)e);
            }
        }
        return branches;
    }

    public String createBranch(CreateBranchDto dto) throws OperationNotSupportedException, AuthenticationException, RepositoryNotFoundException {
        String error = null;
        GitConnection conn = (GitConnection)this.getConnection(this.address, dto.getPathToLocalRepos());
        if (dto.getUsername() == null) {
            dto.setUsername("anonymous");
        }
        if (dto.getPassword() == null) {
            dto.setPassword("anonymous");
        }
        UsernamePasswordCredentialsProvider credentials = new UsernamePasswordCredentialsProvider(dto.getUsername(), dto.getPassword());
        try {
            Git git;
            block22: {
                conn.updateRepository(dto.getUsername(), dto.getPassword());
                File localDirectory = conn.getLocalDirectory();
                conn.changeBranch(dto.getSelectedBranch());
                ObjectId id = conn.getGitRepo().resolve(dto.getSelectedBranch());
                RevWalk revWalk = new RevWalk(conn.getGitRepo());
                RevCommit revCommit = revWalk.parseCommit((AnyObjectId)id);
                git = Git.open((File)localDirectory);
                CreateBranchCommand createBranch = git.branchCreate();
                createBranch.setName(dto.getNewBranchName());
                createBranch.setStartPoint(revCommit);
                try {
                    createBranch.call();
                }
                catch (GitAPIException e) {
                    if (!log.isErrorEnabled()) break block22;
                    log.error((Object)("Can not create local branch " + dto.getNewBranchName() + " from " + dto.getSelectedBranch()), (Throwable)e);
                    error = "error";
                }
            }
            conn.changeBranch(dto.getNewBranchName());
            PushCommand push = git.push();
            push.setRemote(this.address);
            push.setCredentialsProvider((CredentialsProvider)credentials);
            try {
                push.call();
            }
            catch (GitAPIException e) {
                block24: {
                    String logMessage = "Can not push";
                    if (e instanceof NoHeadException) {
                        logMessage = "Can not push : the Git repository has no HEAD reference";
                    } else if (e instanceof UnmergedPathsException) {
                        logMessage = "Can not push : conflicts found (unmerged paths)";
                    } else if (e instanceof ConcurrentRefUpdateException) {
                        logMessage = "Can not push : someone else is updating the HEAD or the branch";
                    } else if (e instanceof WrongRepositoryStateException) {
                        logMessage = "Can not push : the repository is not in the right state";
                    } else if (e instanceof RejectCommitException) {
                        logMessage = "Can not push : commit rejected";
                    }
                    if (log.isErrorEnabled()) {
                        log.error((Object)logMessage, (Throwable)e);
                    }
                    DeleteBranchCommand deleteBranch = git.branchDelete();
                    deleteBranch.setBranchNames(new String[]{dto.getNewBranchName()});
                    deleteBranch.setForce(true);
                    try {
                        deleteBranch.call();
                    }
                    catch (GitAPIException e1) {
                        if (!log.isErrorEnabled()) break block24;
                        log.error((Object)"Can not delete the new local branch", (Throwable)e1);
                    }
                }
                if (e.getMessage().endsWith("not authorized")) {
                    throw new AuthenticationException("Authentication error");
                }
                throw new RepositoryNotFoundException("Can not reach the remote repository");
            }
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can not open local Git repository", (Throwable)e);
            }
            error = "error";
        }
        return error;
    }

    public String changeBranch(String branchName, String pathToLocalRepos, String username, String password) throws OperationNotSupportedException {
        String error = null;
        GitConnection conn = (GitConnection)this.getConnection(this.address, pathToLocalRepos);
        try {
            conn.updateRepository(username, password);
            try {
                conn.changeBranch(branchName);
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Can not change branch to " + branchName), (Throwable)e);
                }
                error = "error";
            }
        }
        catch (RepositoryNotFoundException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can not reach repository " + this.address), (Throwable)e);
            }
            error = "error";
        }
        return error;
    }

    public boolean supportsPush() {
        return true;
    }

    public boolean filesDirectlyAccessible() {
        return false;
    }

    public ScmConnection getConnection(String address, String pathToLocalRepos) {
        GitConnection gitConn;
        block2: {
            gitConn = null;
            this.address = address;
            try {
                gitConn = new GitConnection(address, pathToLocalRepos);
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("Can not connect to Git repository at " + address));
            }
        }
        return gitConn;
    }

    public ScmFileManager getFileManager(ScmConnection connection) {
        GitFileManager fileManager = null;
        if (connection instanceof GitConnection) {
            try {
                fileManager = new GitFileManager((GitConnection)connection);
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can not connect to Git repository", (Throwable)e);
                }
            }
        } else {
            throw new SweInternalException("Can not get Git file manager for a non-Git connection");
        }
        return fileManager;
    }

    public boolean addressSeemsCompatible(String address) {
        return address.contains(".git") || address.startsWith("git://") || address.contains("git.");
    }

    public String getDefaultBranchName() throws OperationNotSupportedException {
        return "master";
    }
}

