/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.converter.LocaleConverter;
import org.nuiton.i18n.format.I18nMessageFormatter;
import org.nuiton.i18n.format.StringFormatI18nMessageFormatter;

public class I18nUtil {
    private static final Log log = LogFactory.getLog(I18nUtil.class);
    public static final String ISO_8859_1_ENCODING = "ISO-8859-1";
    public static final String UTF_8_ENCODING = "UTF-8";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    public static final I18nMessageFormatter DEFAULT_MESSAGE_FORMATTER = new StringFormatI18nMessageFormatter();
    public static final Locale DEFAULT_LOCALE = Locale.UK;
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final LocaleConverter LOCALE_CONVERTER = new LocaleConverter();

    public static Locale[] parseLocales(String str) throws IllegalArgumentException {
        String[] bundlesToUse;
        ArrayList<Locale> result = new ArrayList<Locale>();
        for (String value : bundlesToUse = str.split(",")) {
            String s2 = value.trim();
            try {
                Locale l = LOCALE_CONVERTER.valueOf(s2);
                result.add(l);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("bundle " + s2 + " is not a valid locale", e);
            }
        }
        return result.toArray(new Locale[0]);
    }

    public static Locale newLocale(String str) {
        if (str == null) {
            return I18nUtil.newLocale(null, null);
        }
        try {
            return LOCALE_CONVERTER.valueOf(str);
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn("could not load locale '" + str + " for reason : " + e.getMessage());
            }
            return DEFAULT_LOCALE;
        }
    }

    public static Locale newLocale(String language, String country) {
        if (language == null) {
            language = System.getProperty("user.language", DEFAULT_LOCALE.getLanguage());
            country = System.getProperty("user.country", DEFAULT_LOCALE.getCountry());
        }
        return I18nUtil.newLocale(language + (country == null ? "" : '_' + country));
    }

    public static boolean containsDirectDirectory(URL url, String directory) throws IOException {
        String fileName = url.getFile();
        File file = new File(fileName.replaceAll("%20", " "));
        if (!file.exists()) {
            return false;
        }
        if (I18nUtil.isJar(fileName) || I18nUtil.isZip(fileName)) {
            if (log.isTraceEnabled()) {
                log.trace("zip to search " + file);
            }
            try {
                return new ZipFile(file).getEntry(directory + "/") != null;
            }
            catch (ZipException ze) {
                if (log.isWarnEnabled()) {
                    log.warn("Unable to open JAR/ZIP: " + fileName, ze);
                }
                return false;
            }
        }
        if (file.isDirectory()) {
            if (log.isTraceEnabled()) {
                log.trace("directory to search " + file);
            }
            return new File(file, directory).exists();
        }
        if (log.isWarnEnabled()) {
            log.warn("unknown resource type " + url);
        }
        return false;
    }

    public static boolean isJar(String name) {
        if (name != null && name.length() > 4) {
            String ext = name.substring(name.length() - 4, name.length());
            return ".jar".equalsIgnoreCase(ext);
        }
        return false;
    }

    public static boolean isZip(String name) {
        if (name != null && name.length() > 4) {
            String ext = name.substring(name.length() - 4, name.length());
            return ".zip".equalsIgnoreCase(ext);
        }
        return false;
    }

    public static List<URL> getURLsFromDirectory(File repository, String pattern) {
        try {
            if (log.isTraceEnabled()) {
                log.trace("search '" + pattern + "' in " + repository);
            }
            ArrayList<URL> urlList = new ArrayList<URL>();
            File[] filesList = repository.listFiles();
            if (filesList != null) {
                for (File file : filesList) {
                    String name = file.getAbsolutePath();
                    if (log.isTraceEnabled()) {
                        log.trace("directory: " + repository + " name: " + name);
                    }
                    if (file.exists() && file.isDirectory()) {
                        urlList.addAll(I18nUtil.getURLsFromDirectory(file, pattern));
                        continue;
                    }
                    if (pattern != null && !name.matches(pattern)) continue;
                    URL url = file.toURI().toURL();
                    if (log.isTraceEnabled()) {
                        log.trace("directory: " + repository + " url: " + url);
                    }
                    urlList.add(url);
                }
            }
            if (log.isTraceEnabled()) {
                log.trace("found with pattern '" + pattern + "' : " + urlList);
            }
            return urlList;
        }
        catch (MalformedURLException eee) {
            throw new IllegalArgumentException("Erreur lors de la conversion de l'url " + repository + " (pattern " + pattern + ") " + eee.getMessage(), eee);
        }
    }

    public static URL[] getDeepURLs(URLClassLoader loader) {
        Stack<URL> urlToTreate = new Stack<URL>();
        ArrayList<URL> urlTreated = new ArrayList<URL>();
        URL[] result = I18nUtil.getURLs(loader);
        urlToTreate.addAll(Arrays.asList(result));
        while (!urlToTreate.isEmpty()) {
            URL currentUrl = (URL)urlToTreate.pop();
            urlTreated.add(currentUrl);
            if (!I18nUtil.isJar(currentUrl.toString())) continue;
            try {
                URL[] newArrayURLs = I18nUtil.getClassPathURLsFromJarManifest(currentUrl);
                if (newArrayURLs == null) continue;
                for (URL newURL : newArrayURLs) {
                    if (urlTreated.contains(newURL) || urlToTreate.contains(newURL)) continue;
                    urlToTreate.add(newURL);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("error with url" + currentUrl + " for reason : " + e.getMessage());
            }
        }
        return urlTreated.toArray(new URL[urlToTreate.size()]);
    }

    public static URL[] getURLs(URLClassLoader classLoader) {
        URL[] result;
        Method m3;
        if (classLoader == null) {
            classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        }
        try {
            m3 = classLoader.getClass().getMethod("getAllURLs", new Class[0]);
        }
        catch (Exception e) {
            m3 = null;
        }
        if (m3 == null) {
            result = classLoader.getURLs();
        } else {
            try {
                result = (URL[])m3.invoke((Object)classLoader, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL[] getClassPathURLsFromJarManifest(URL jarURL) throws IOException, URISyntaxException {
        URL[] result;
        try (ZipFile jar = null;){
            String jarPath = jarURL.toURI().getPath();
            File jarFile = new File(jarPath);
            if (log.isDebugEnabled()) {
                log.debug("class-path jar to scan " + jarPath);
            }
            jar = new JarFile(jarFile);
            File container = jarFile.getParentFile();
            Manifest mf = ((JarFile)jar).getManifest();
            String classPath = null;
            if (mf != null && mf.getMainAttributes() != null) {
                classPath = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            }
            String[] paths = classPath != null ? classPath.split(" ") : EMPTY_STRING_ARRAY;
            result = new URL[paths.length + 1];
            result[0] = jarURL;
            for (int i = 0; i < paths.length; ++i) {
                String s2 = paths[i];
                if (s2.indexOf(58) != -1) {
                    result[i + 1] = new URL(s2);
                    continue;
                }
                File path = s2.startsWith(".") || !s2.startsWith("/") ? new File(container, s2) : new File(s2);
                if (log.isDebugEnabled()) {
                    log.debug(path);
                }
                result[i + 1] = path.toURI().toURL();
            }
            jar.close();
        }
        return result;
    }
}

