/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.util.Arrays;
import org.apache.commons.collections.primitives.ArrayFloatList;
import org.apache.commons.collections.primitives.FloatCollection;
import org.nuiton.math.matrix.MapFunction;
import org.nuiton.math.matrix.Vector;
import org.nuiton.math.matrix.VectorForEachFunction;
import org.nuiton.math.matrix.VectorIterator;
import org.nuiton.math.matrix.VectorIteratorImpl;

public class FloatVector
implements Vector {
    protected long capacity = 0L;
    protected float defaultValue = 0.0f;
    protected long[] position;
    protected int positionSize = 0;
    protected ArrayFloatList data;

    public FloatVector() {
    }

    public FloatVector(long capacity) {
        this.init(capacity);
    }

    public FloatVector(long capacity, float defaultValue) {
        this(capacity);
        this.defaultValue = defaultValue;
    }

    @Override
    public void init(long capacity) {
        if (capacity > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("FloatBigVector don't support this capacity : " + capacity);
        }
        if (this.data == null) {
            this.capacity = capacity;
            this.position = new long[8];
            this.data = new ArrayFloatList();
            Arrays.fill(this.position, Integer.MAX_VALUE);
        }
    }

    @Override
    public String getInfo() {
        return "Float vector sparse: " + this.data.size() + "/" + this.size();
    }

    @Override
    public long getNumberOfAssignedValue() {
        return this.data.size();
    }

    @Override
    public long size() {
        return this.capacity;
    }

    @Override
    @Deprecated
    public double getMaxOccurence() {
        return this.getMaxOccurrence();
    }

    @Override
    public double getMaxOccurrence() {
        float result = this.defaultValue;
        float[] tmp = this.data.toArray();
        if (this.capacity < (long)(2 * tmp.length)) {
            Arrays.sort(tmp);
            int max = 1;
            int count = 1;
            result = tmp[0];
            float old = tmp[0];
            float current = tmp[0];
            for (int i = 1; max < tmp.length - i + count && i < tmp.length; ++i) {
                current = tmp[i];
                if (current == old) {
                    ++count;
                    continue;
                }
                if (count > max) {
                    max = count;
                    result = old;
                }
                count = 1;
                old = current;
            }
            if (count > max) {
                max = count;
                result = current;
            }
            if ((long)max <= this.capacity - (long)tmp.length) {
                result = this.defaultValue;
            }
        }
        return result;
    }

    protected void checkPos(long pos) {
        if (pos < 0L || pos >= this.capacity) {
            throw new IllegalArgumentException("pos " + pos + " is not in [0, " + this.capacity + "]");
        }
    }

    @Override
    public double getValue(long pos) {
        this.checkPos(pos);
        float result = this.defaultValue;
        int index = this.findIndex(pos);
        if (index >= 0) {
            result = this.data.get(index);
        }
        return result;
    }

    @Override
    public void setValue(long pos, double dValue) {
        this.checkPos(pos);
        float value = (float)dValue;
        int index = this.findIndex(pos);
        if (index >= 0) {
            if (value == this.defaultValue) {
                this.removeElementAt(index);
                this.data.removeElementAt(index);
            } else {
                this.data.set(index, value);
            }
        } else if (value != this.defaultValue) {
            index = -index - 1;
            this.addElementAt(index, pos);
            this.data.add(index, value);
        }
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof FloatVector && this.defaultValue == ((FloatVector)o).defaultValue) {
            FloatVector other = (FloatVector)o;
            result = Arrays.equals(this.position, other.position) && this.data.equals((Object)other.data);
        } else if (o instanceof Vector) {
            Vector other = (Vector)o;
            result = this.size() == other.size();
            int i = 0;
            while ((long)i < this.size() && result) {
                result = this.getValue(i) == other.getValue(i);
                ++i;
            }
        }
        return result;
    }

    protected int findIndex(long pos) {
        return Arrays.binarySearch(this.position, (long)((int)pos));
    }

    protected void ensureCapacity(int mincap) {
        if (mincap > this.position.length) {
            int newcap = this.position.length * 3 / 2 + 1;
            long[] olddata = this.position;
            this.position = new long[newcap >= mincap ? newcap : mincap];
            System.arraycopy(olddata, 0, this.position, 0, this.positionSize);
            for (int i = this.positionSize; i < this.position.length; ++i) {
                this.position[i] = Integer.MAX_VALUE;
            }
        }
    }

    protected void addElementAt(int index, long element) {
        this.ensureCapacity(this.positionSize + 1);
        int numtomove = this.positionSize - index;
        System.arraycopy(this.position, index, this.position, index + 1, numtomove);
        this.position[index] = element;
        ++this.positionSize;
    }

    protected long removeElementAt(int index) {
        long oldval = this.position[index];
        int numtomove = this.positionSize - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this.position, index + 1, this.position, index, numtomove);
        }
        --this.positionSize;
        this.position[this.positionSize] = Integer.MAX_VALUE;
        return oldval;
    }

    @Override
    public boolean isImplementedPaste(Vector v) {
        return v instanceof FloatVector;
    }

    @Override
    public boolean isImplementedMap() {
        return true;
    }

    @Override
    public void paste(Vector v) {
        FloatVector fbv = (FloatVector)v;
        this.capacity = fbv.capacity;
        this.defaultValue = fbv.defaultValue;
        this.positionSize = fbv.positionSize;
        this.position = new long[fbv.position.length];
        System.arraycopy(fbv.position, 0, this.position, 0, this.position.length);
        this.data.clear();
        this.data.addAll((FloatCollection)fbv.data);
    }

    @Override
    public void map(MapFunction f) {
        this.defaultValue = (float)f.apply(this.defaultValue);
        for (int i = this.data.size() - 1; i >= 0; --i) {
            double value = f.apply(this.data.get(i));
            if (value == (double)this.defaultValue) {
                this.removeElementAt(i);
                this.data.removeElementAt(i);
                continue;
            }
            this.data.set(i, (float)value);
        }
    }

    @Override
    public VectorIterator iterator() {
        return new VectorIteratorImpl(this);
    }

    @Override
    public VectorIterator iteratorNotZero() {
        return new VectorIteratorImpl(this, 0.0);
    }

    @Override
    public void forEachNotZero(VectorForEachFunction f) {
        if (this.defaultValue == 0.0f) {
            long max = this.getNumberOfAssignedValue();
            for (long i = 0L; i < max; ++i) {
                f.apply(i, this.getValue(i));
            }
        } else {
            Vector.super.forEachNotZero(f);
        }
    }
}

