/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXContextEntryDef;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NavigationTreeSelectionAdapter
implements TreeSelectionListener {
    private static final Log log = LogFactory.getLog(NavigationTreeSelectionAdapter.class);
    public static final String NAVIGATION_SELECTED_BEAN = "navigation-selected-bean";
    public static final JAXXContextEntryDef<String> NAVIGATION_SELECTED_PATH_ENTRY_DEF = JAXXContextEntryDef.newDef((String)"navigation-selected-path", String.class);
    public static final JAXXContextEntryDef<NavigationTreeModel.NavigationTreeNode> NAVIGATION_SELECTED_NODE_ENTRY_DEF = JAXXContextEntryDef.newDef((String)"navigation-selected-node", NavigationTreeModel.NavigationTreeNode.class);
    public static final JAXXContextEntryDef<Boolean> GO_BACK_DEF = JAXXContextEntryDef.newDef((String)"goBack", Boolean.class);
    protected Class<? extends JAXXObject> defaultUIClass;
    protected Class<? extends JAXXAction> defaultUIHandlerClass;
    protected JAXXObject context;
    protected Strategy strategy;

    protected NavigationTreeSelectionAdapter(Class<? extends JAXXObject> defaultUIClass, Class<? extends JAXXAction> defaultUIHandlerClass, JAXXObject context, Strategy strategy) {
        this.defaultUIClass = defaultUIClass;
        this.defaultUIHandlerClass = defaultUIHandlerClass;
        this.context = context;
        this.strategy = strategy;
    }

    protected abstract NavigationTreeModel getNavigationTreeModel();

    protected abstract Component getCurrentUI();

    protected abstract Component getUI(NavigationTreeModel.NavigationTreeNode var1);

    protected abstract boolean closeUI(TreeSelectionEvent var1, Component var2) throws Exception;

    protected abstract Component createUI(NavigationTreeModel.NavigationTreeNode var1) throws Exception;

    protected abstract void openUI(Component var1, NavigationTreeModel.NavigationTreeNode var2) throws Exception;

    protected abstract void goBackToPreviousNode(TreeSelectionEvent var1, Exception var2);

    protected NavigationTreeModel.NavigationTreeNode prepareNode(TreeSelectionEvent event) {
        NavigationTreeModel.NavigationTreeNode node = (NavigationTreeModel.NavigationTreeNode)event.getPath().getLastPathComponent();
        if (node.getJaxxClass() == null) {
            node.setJaxxClass(this.defaultUIClass);
        }
        if (node.getJaxxActionClass() == null) {
            node.setJaxxActionClass(this.defaultUIHandlerClass);
        }
        return node;
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        if (event.getOldLeadSelectionPath() != null && event.getOldLeadSelectionPath().equals(event.getPath())) {
            return;
        }
        Boolean goBack = (Boolean)GO_BACK_DEF.getContextValue((JAXXContext)this.context);
        if (goBack != null && goBack.booleanValue()) {
            GO_BACK_DEF.removeContextValue((JAXXContext)this.context);
            return;
        }
        try {
            NavigationTreeModel.NavigationTreeNode node = this.prepareNode(event);
            String path = node.getContextPath();
            if (log.isTraceEnabled()) {
                log.trace((Object)path);
            }
            Component newUI = this.getUI(node);
            Component component = this.getCurrentUI();
            if (newUI != null && this.strategy == Strategy.PER_NODE && newUI.equals(component)) {
                return;
            }
            if (!this.closeUI(event, component)) {
                GO_BACK_DEF.setContextValue((JAXXContext)this.context, (Object)Boolean.TRUE);
                this.goBackToPreviousNode(event, null);
                return;
            }
            node.cachedBean = null;
            if (node.renderer != null) {
                node.renderer.setRendererCachedValue(null);
            }
            Object data = this.getNavigationTreeModel().getJAXXContextValue((JAXXContext)this.context, path);
            this.addSelectedBeanInContext(node, data);
            if (newUI == null) {
                newUI = this.createUI(node);
            }
            NAVIGATION_SELECTED_PATH_ENTRY_DEF.setContextValue((JAXXContext)this.context, (Object)node.getContextPath());
            NAVIGATION_SELECTED_NODE_ENTRY_DEF.setContextValue((JAXXContext)this.context, (Object)node);
            this.openUI(newUI, node);
        }
        catch (Exception e) {
            this.goBackToPreviousNode(event, e);
        }
    }

    protected void addSelectedBeanInContext(NavigationTreeModel.NavigationTreeNode node, Object data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("find data for contextPath <" + node.getContextPath() + "> : " + (data == null ? null : data.getClass())));
        }
        this.context.removeContextValue(Object.class, NAVIGATION_SELECTED_BEAN);
        if (data != null) {
            this.context.setContextValue(data, NAVIGATION_SELECTED_BEAN);
            this.context.setContextValue(data);
        }
    }

    protected String getNodeConstraints(NavigationTreeModel.NavigationTreeNode node) {
        String constraints;
        switch (this.strategy) {
            case PER_NODE: {
                constraints = node.getContextPath();
                break;
            }
            case PER_UI_TYPE: {
                constraints = node.getJaxxClass().getName();
                break;
            }
            default: {
                throw new IllegalArgumentException("could not find constraint for node : " + node);
            }
        }
        return constraints;
    }

    protected void returnToPreviousNode(JTree tree, TreeSelectionEvent event) {
        TreePath oldPath = event.getOldLeadSelectionPath();
        if (oldPath != null) {
            tree.setSelectionPath(oldPath);
        }
    }

    public static enum Strategy {
        PER_NODE,
        PER_UI_TYPE;

    }
}

