/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation;

import java.awt.Component;
import java.io.Serializable;
import javax.swing.JPanel;
import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXInitialContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.navigation.NavigationTreeHandler;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NavigationTreeHandlerWithCardLayout
extends NavigationTreeHandler {
    private static final Log log = LogFactory.getLog(NavigationTreeHandlerWithCardLayout.class);

    protected abstract JPanel getContentContainer();

    protected abstract CardLayout2 getContentLayout();

    public NavigationTreeHandlerWithCardLayout(Class<? extends JAXXObject> defaultUIClass, Class<? extends JAXXAction> defaultUIHandlerClass, JAXXObject context, NavigationTreeHandler.Strategy strategy) {
        super(defaultUIClass, defaultUIHandlerClass, context, strategy);
        if (this.getContentContainer() == null) {
            throw new IllegalArgumentException("could not have a null 'contentContainer' in ui " + context);
        }
        if (this.getContentLayout() == null) {
            throw new IllegalArgumentException("could not have a null 'contentLayout' in ui " + context);
        }
    }

    @Override
    protected Component getCurrentUI() {
        CardLayout2 layout = this.getContentLayout();
        JPanel container = this.getContentContainer();
        return layout.getVisibleComponent(container);
    }

    @Override
    protected Component getUI(NavigationTreeModel.NavigationTreeNode node) {
        CardLayout2 layout = this.getContentLayout();
        JPanel container = this.getContentContainer();
        String path = this.getNodeConstraints(node);
        return layout.contains((Serializable)((Object)path)) ? layout.getComponent(container, path) : null;
    }

    @Override
    protected void openUI(Component newUI, NavigationTreeModel.NavigationTreeNode node) throws Exception {
        CardLayout2 layout = this.getContentLayout();
        JPanel container = this.getContentContainer();
        layout.show(container, this.getNodeConstraints(node));
    }

    @Override
    protected boolean closeUI(Component component) throws Exception {
        return true;
    }

    @Override
    protected JAXXContext createUIContext(NavigationTreeModel.NavigationTreeNode node) throws Exception {
        if (node.getJaxxActionClass() == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("no action associated with ui " + node.getJaxxClass()));
            }
            return this.context;
        }
        JAXXAction action = this.getJAXXAction(node.getJaxxActionClass());
        JAXXInitialContext uiContext = action.init((JAXXContext)this.context, new Object[0]);
        return uiContext;
    }

    @Override
    protected Component createUI(NavigationTreeModel.NavigationTreeNode node) throws Exception {
        JAXXContext uiContext = this.createUIContext(node);
        JAXXObject newUI = node.getJaxxClass().getConstructor(JAXXContext.class).newInstance(uiContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("instanciate new ui " + newUI));
        }
        this.getContentContainer().add((Component)newUI, this.getNodeConstraints(node));
        return (Component)newUI;
    }
}

