/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.api.internal.binding;

import java.beans.PropertyChangeEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.api.JAXXObject;
import org.nuiton.jaxx.runtime.api.internal.binding.JAXXBinding;
import org.nuiton.jaxx.runtime.api.internal.binding.JAXXBindings;

public abstract class DefaultJAXXBinding
implements JAXXBinding {
    private static final Log log = LogFactory.getLog(DefaultJAXXBinding.class);
    private static long NB;
    private long nb;
    private final String id;
    protected final JAXXObject source;
    protected final boolean defaultBinding;
    protected final boolean reloadAfterFire;
    private static final String LOG_START_PATTERN = ">>     (hits:%1$5d, total:%2$5d) on %3$s";
    private static final String LOG_END_PATTERN = "<< %4$3d (hits:%1$5d, total:%2$5d) on %3$s";

    public DefaultJAXXBinding(JAXXObject source, String id, boolean defaultBinding) {
        this(source, id, defaultBinding, false);
    }

    public DefaultJAXXBinding(JAXXObject source, String id, boolean defaultBinding, boolean reloadAfterFire) {
        this.source = source;
        this.id = id;
        this.defaultBinding = defaultBinding;
        this.reloadAfterFire = reloadAfterFire;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public JAXXObject getSource() {
        return this.source;
    }

    @Override
    public boolean isDefaultBinding() {
        return this.defaultBinding;
    }

    public String toString() {
        return super.toString() + ":" + this.id;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        long count = NB++;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format(LOG_START_PATTERN, ++this.nb, NB, this));
        }
        this.source.processDataBinding(this.id);
        if (this.reloadAfterFire) {
            JAXXBindings.reloadBinding(this);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format(LOG_END_PATTERN, ++this.nb, ++NB, this, NB - count));
        }
    }
}

