/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.api.internal.awt.visitor;

import java.awt.Component;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.api.internal.awt.visitor.ComponentTreeNode;
import org.nuiton.jaxx.runtime.api.internal.awt.visitor.ComponentTreeNodeVisitor;

public class DebugComponentTreeNodeVisitor
implements ComponentTreeNodeVisitor {
    private static final Log log = LogFactory.getLog(DebugComponentTreeNodeVisitor.class);
    protected boolean debug;
    protected int level = 0;
    protected StringBuilder sb = new StringBuilder();

    public void parse(ComponentTreeNode componentTree) {
        this.sb = new StringBuilder();
        componentTree.visit(this);
        String message = this.sb.toString();
        if (this.debug) {
            log.debug((Object)message);
        } else {
            log.info((Object)message);
        }
    }

    @Override
    public void startNode(ComponentTreeNode componentTree) {
        String message = StringUtils.leftPad((String)" ", (int)(2 * this.level));
        this.sb.append("\n").append(message).append(this.getMessage(componentTree));
        ++this.level;
    }

    @Override
    public void endNode(ComponentTreeNode componentTree) {
        --this.level;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getMessage(ComponentTreeNode componentTree) {
        Component userObject = componentTree.getUserObject();
        return userObject.getClass().getSimpleName() + "::" + userObject.getName();
    }
}

