/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.nuiton.util.Version;

public class VersionUtil {
    public static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+(?:\\.(?:\\d+))*)(?:-(\\w+?)-(\\d+?)){0,1}$");
    public static final VersionComparator DEFAULT_VERSION_COMPARATOR = new VersionComparator();
    public static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";

    public static Version valueOf(int ... numbers) {
        Version version = VersionUtil.valueOf(null, null, numbers);
        return version;
    }

    public static Version valueOf(String classifier, Integer classifierNumber, int ... numbers) {
        Version v = new Version(classifier, classifierNumber, numbers);
        return v;
    }

    public static Version valueOf(String version) {
        Version v = new Version(version);
        return v;
    }

    public static Version addClassifier(Version version, String classifier, Integer classifierNumber) throws NullPointerException, IllegalArgumentException {
        Version result = null;
        if (classifier == null) {
            throw new NullPointerException("classifier can not be null");
        }
        if (classifierNumber == null) {
            throw new NullPointerException("classifierNumber can not be null");
        }
        if (version.hasClassifier()) {
            throw new IllegalArgumentException("version " + version + "contains already a classifier ");
        }
        result = VersionUtil.valueOf(classifier, classifierNumber, version.getNumbers());
        return result;
    }

    public static Version removeClassifier(Version version) throws IllegalArgumentException {
        Version result = null;
        if (!version.hasClassifier()) {
            throw new IllegalArgumentException("version " + version + "does no contain a classifier ");
        }
        result = VersionUtil.valueOf(version.getNumbers());
        return result;
    }

    public static Version inc(Version v) {
        int nbComponents = v.getNbComponents();
        int[] newNumbers = Arrays.copyOf(v.numbers, nbComponents);
        String newClassifier = v.classifier;
        Integer newClassifierNumber = v.classifierNumber;
        if (v.hasClassifier()) {
            Integer n = newClassifierNumber;
            Integer n2 = newClassifierNumber = Integer.valueOf(newClassifierNumber + 1);
        } else {
            newNumbers[nbComponents - 1] = newNumbers[nbComponents - 1] + 1;
        }
        Version result = VersionUtil.valueOf(newClassifier, newClassifierNumber, newNumbers);
        return result;
    }

    public static String removeSnapshot(String version) throws NullPointerException {
        if (version == null) {
            throw new NullPointerException("version parameter can not be null");
        }
        int index = version.indexOf(SNAPSHOT_SUFFIX);
        if (index > -1) {
            version = version.substring(0, index);
        }
        return version;
    }

    public static class VersionComparator
    implements Comparator<Version> {
        @Override
        public int compare(Version o1, Version o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            int result = this.compareNumbers(o1, o2);
            if (result != 0) {
                return result;
            }
            result = this.compareClassifier(o1, o2);
            if (result != 0) {
                return result;
            }
            result = this.compareClassifierNumber(o1, o2);
            return result;
        }

        public int compareNumbers(Version o1, Version o2) {
            int nbComponents1 = o1.numbers.length;
            int nbComponents2 = o2.numbers.length;
            int minlen = Math.min(nbComponents1, nbComponents2);
            for (int i = 0; i < minlen; ++i) {
                int t1 = o1.numbers[i];
                int t2 = o2.numbers[i];
                if (t1 == t2) continue;
                return t1 - t2;
            }
            return nbComponents1 - nbComponents2;
        }

        public int compareClassifier(Version o1, Version o2) {
            if (o1.hasClassifier() && o2.hasClassifier()) {
                return o1.classifier.compareTo(o2.classifier);
            }
            if (!o1.hasClassifier()) {
                return 1;
            }
            if (!o2.hasClassifier()) {
                return -1;
            }
            return 0;
        }

        public int compareClassifierNumber(Version o1, Version o2) {
            return o1.classifierNumber - o2.classifierNumber;
        }
    }
}

