/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.beans.Statement;
import java.util.Iterator;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ListenerSet;

public class CategorisedListenerSet<Listener> {
    private static Log log = LogFactory.getLog(CategorisedListenerSet.class);
    public static final Object ALL = new Object();
    protected WeakHashMap<Object, ListenerSet<Listener>> listeners = new WeakHashMap();
    protected WeakHashMap<Object, Object> categoryParent = new WeakHashMap();
    protected boolean isClassCategory = true;

    public CategorisedListenerSet() {
    }

    public CategorisedListenerSet(Class listenerClass, boolean isClassCategory) {
        this.isClassCategory = isClassCategory;
    }

    protected void checkCategory(Object category) {
        if (category == ALL) {
            throw new IllegalArgumentException("ALL category can't be use to add listener or add Category");
        }
    }

    public void addCategory(Object parent, Object newCategory) {
        this.checkCategory(parent);
        this.checkCategory(newCategory);
        this.categoryParent.put(newCategory, parent);
    }

    public void add(Object category, Listener l) {
        this.checkCategory(category);
        ListenerSet<Listener> listeners = this.getListeners(category);
        listeners.add(l);
    }

    public void remove(Object category, Listener l) {
        ListenerSet<Listener> listeners = this.getListeners(category);
        listeners.remove(l);
    }

    public void fire(Object category, String methodName, Object event) throws Exception {
        if (log != null && log.isTraceEnabled()) {
            log.trace((Object)("fire category: " + category + " method: " + methodName));
        }
        ListenerSet<Listener> ls = this.getAllListeners(category);
        ls.fire(methodName, event);
    }

    public void fire(Object category, String methodName) throws Exception {
        for (Listener l : this.getAllListeners(category)) {
            Statement stm = new Statement(l, methodName, null);
            stm.execute();
        }
    }

    public Iterator<Listener> iterator(Object category) {
        return this.getAllListeners(category).iterator();
    }

    protected ListenerSet<Listener> getAllListeners(Object category) {
        ListenerSet<Listener> result = new ListenerSet<Listener>();
        if (category == ALL) {
            for (ListenerSet<Listener> ls : this.listeners.values()) {
                result.addAll(ls);
            }
        } else {
            Object parentCategory = category;
            while (parentCategory != null) {
                result.addAll(this.getListeners(parentCategory));
                if (this.isClassCategory && parentCategory instanceof Class) {
                    result.addAll(this.getListenersClass((Class)parentCategory));
                }
                parentCategory = this.categoryParent.get(parentCategory);
            }
        }
        if (log != null && log.isTraceEnabled()) {
            log.trace((Object)("getAllListeners category: " + category + " result: " + result));
        }
        return result;
    }

    protected ListenerSet<Listener> getListenersClass(Class category) {
        ListenerSet<Listener> result = new ListenerSet<Listener>();
        Class superClass = category.getSuperclass();
        if (superClass != null) {
            result.addAll(this.getAllListeners(superClass));
        }
        for (Class<?> c : category.getInterfaces()) {
            result.addAll(this.getAllListeners(c));
        }
        return result;
    }

    protected ListenerSet<Listener> getListeners(Object category) {
        ListenerSet<Listener> result = this.listeners.get(category);
        if (result == null) {
            result = new ListenerSet();
            this.listeners.put(category, result);
        }
        if (log != null && log.isTraceEnabled()) {
            log.trace((Object)("getListeners category: " + category + " result: " + result));
        }
        return result;
    }

    public String toString() {
        return "Listeners Category: " + this.categoryParent + "\nListener: " + this.listeners;
    }
}

