/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.wizard;

import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.util.List;
import jaxx.runtime.swing.wizard.WizardModel;
import jaxx.runtime.swing.wizard.WizardOperationState;
import jaxx.runtime.swing.wizard.WizardStep;
import jaxx.runtime.swing.wizard.WizardUI;
import org.apache.commons.logging.Log;

public class WizardUtil {
    protected WizardUtil() {
    }

    public static boolean acceptStates(WizardOperationState state, WizardOperationState ... accepted) {
        for (WizardOperationState s : accepted) {
            if (s != state) continue;
            return true;
        }
        return false;
    }

    public static boolean rejectStates(WizardOperationState state, WizardOperationState ... rejected) {
        for (WizardOperationState s : rejected) {
            if (s != state) continue;
            return false;
        }
        return true;
    }

    public static void addDebugLogListener(final Log log, WizardModel model) {
        if (log.isDebugEnabled()) {
            model.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    log.debug((Object)(evt.getPropertyName() + " <" + evt.getOldValue() + " - " + evt.getNewValue() + ">"));
                }
            });
        }
    }

    public static void addTraceLogListener(final Log log, WizardModel model) {
        if (log.isTraceEnabled()) {
            model.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    log.trace((Object)(evt.getPropertyName() + " <" + evt.getOldValue() + " - " + evt.getNewValue() + ">"));
                }
            });
        }
    }

    public static <E extends WizardStep, M extends WizardModel<E>> void installWizardUIListeners(final WizardUI<E, M> ui) {
        ((WizardModel)ui.getModel()).addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("wasStarted".equals(propertyName)) {
                    ui.onWasStarted();
                    return;
                }
                if ("steps".equals(propertyName)) {
                    List steps = (List)evt.getNewValue();
                    ui.onStepsChanged(steps.toArray((WizardStep[])Array.newInstance(((WizardModel)ui.getModel()).stepClass, steps.size())));
                    return;
                }
                if ("step".equals(propertyName)) {
                    ui.onStepChanged((WizardStep)evt.getNewValue());
                    return;
                }
                if ("modelState".equals(propertyName)) {
                    ui.onModelStateChanged((WizardOperationState)((Object)evt.getNewValue()));
                    return;
                }
                if ("operationState".equals(propertyName)) {
                    IndexedPropertyChangeEvent e = (IndexedPropertyChangeEvent)evt;
                    int stepIndex = e.getIndex();
                    WizardStep step = (WizardStep)((WizardModel)ui.getModel()).getSteps().get(stepIndex);
                    ui.onOperationStateChanged(step, (WizardOperationState)((Object)evt.getNewValue()));
                    return;
                }
            }
        });
    }
}

