/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXContextEntryDef;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.navigation.NavigationUtil;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NavigationTreeModel
extends DefaultTreeModel {
    private static final Log log = LogFactory.getLog(NavigationTreeModel.class);
    private static final long serialVersionUID = 1L;
    protected final String navigationPathSeparator;

    public NavigationTreeModel(TreeNode root, String navigationPathSeparator) {
        super(root);
        this.navigationPathSeparator = navigationPathSeparator;
    }

    @Override
    public NavigationTreeNode getRoot() {
        return (NavigationTreeNode)super.getRoot();
    }

    public NavigationTreeNode findNode(String path) {
        return this.findNode(this.getRoot(), path, (Pattern)null);
    }

    public NavigationTreeNode findNode(String path, String regex) {
        return this.findNode(this.getRoot(), path, regex);
    }

    public NavigationTreeNode findNode(String path, Pattern regex) {
        return this.findNode(this.getRoot(), path, regex);
    }

    public NavigationTreeNode findNode(NavigationTreeNode root, String path) {
        return this.findNode(root, path, (Pattern)null);
    }

    public NavigationTreeNode findNode(NavigationTreeNode root, String path, String regex) {
        return this.findNode(root, path, regex == null ? null : Pattern.compile(regex));
    }

    public NavigationTreeNode findNode(NavigationTreeNode root, String path, Pattern regex) {
        String rootPath;
        if (regex != null) {
            Matcher matcher = regex.matcher(path);
            if (!matcher.matches() || matcher.groupCount() < 1) {
                log.warn((Object)("no matching regex " + regex + " to " + path));
                return null;
            }
            path = matcher.group(1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("matching regex " + regex + " : " + path));
            }
        }
        StringTokenizer stk = new StringTokenizer(path, this.navigationPathSeparator);
        NavigationTreeNode result = root;
        if (root.isRoot() && stk.hasMoreTokens() && !(rootPath = stk.nextToken()).equals(root.getNavigationPath())) {
            return null;
        }
        while (stk.hasMoreTokens()) {
            result = result.getChild(stk.nextToken());
        }
        return result;
    }

    public Object getJAXXContextValue(JAXXContext context, String navigationPath) {
        NavigationTreeNode node = this.findNode(navigationPath, (Pattern)null);
        Object result = this.getJAXXContextValue(context, node);
        return result;
    }

    public Object getJAXXContextValue(JAXXContext context, NavigationTreeNode node) {
        if (node == null) {
            return null;
        }
        return node.getJAXXContextValue(context);
    }

    @Override
    public void nodeChanged(TreeNode node) {
        this.nodeChanged(node, false);
    }

    public void nodeChanged(TreeNode node, boolean deep) {
        NavigationTreeNode n = (NavigationTreeNode)node;
        n.clearCache(!deep);
        super.nodeChanged(node);
        if (deep) {
            Enumeration<? extends TreeNode> childs = node.children();
            while (childs.hasMoreElements()) {
                NavigationTreeNode o = (NavigationTreeNode)childs.nextElement();
                this.nodeChanged(o, true);
            }
        }
    }

    public class NavigationTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        protected String navigationPath;
        protected String cachedNavigationPath;
        protected Class<? extends JAXXObject> jaxxClass;
        protected Class<? extends JAXXAction> jaxxActionClass;
        protected JAXXContextEntryDef<?> jaxxContextEntryDef;
        protected String jaxxContextEntryPath;
        protected transient Object cachedBean;
        protected NavigationUtil.NodeRenderer renderer;
        protected Class<?> internalClass;

        public NavigationTreeNode(Object renderer, Object jaxxContextEntryDef, String navigationPath, Class<? extends JAXXObject> jaxxClass, Class<? extends JAXXAction> jaxxActionClass) {
            super(renderer);
            if (renderer instanceof NavigationUtil.NodeRenderer) {
                this.renderer = (NavigationUtil.NodeRenderer)renderer;
                this.renderer.setNode(this);
            } else if (!(renderer instanceof String) && renderer != null) {
                throw new IllegalArgumentException("to define a renderer, must be a String (simple libelle) or a  " + NavigationUtil.NodeRenderer.class + ", but was " + renderer);
            }
            this.navigationPath = navigationPath;
            this.jaxxClass = jaxxClass;
            this.jaxxActionClass = jaxxActionClass;
            if (jaxxContextEntryDef instanceof JAXXContextEntryDef) {
                this.jaxxContextEntryDef = (JAXXContextEntryDef)jaxxContextEntryDef;
            } else if (jaxxContextEntryDef instanceof String) {
                this.jaxxContextEntryPath = (String)jaxxContextEntryDef;
            } else if (jaxxContextEntryDef != null) {
                throw new IllegalArgumentException("to define a context link, must be a String (jxpath) or a " + JAXXContextEntryDef.class + ", but was " + jaxxContextEntryDef);
            }
        }

        public NavigationTreeNode(Object renderer, JAXXContextEntryDef<?> jaxxContextEntryDef, String jaxxContextEntryPath, String navigationPath, Class<? extends JAXXObject> jaxxClass, Class<? extends JAXXAction> jaxxActionClass) {
            super(renderer);
            if (renderer instanceof NavigationUtil.NodeRenderer) {
                this.renderer = (NavigationUtil.NodeRenderer)renderer;
                this.renderer.setNode(this);
            } else if (!(renderer instanceof String) && renderer != null) {
                throw new IllegalArgumentException("to define a renderer, must be a String (simple libelle) or a  " + NavigationUtil.NodeRenderer.class + ", but was " + renderer);
            }
            this.navigationPath = navigationPath;
            this.jaxxClass = jaxxClass;
            this.jaxxActionClass = jaxxActionClass;
            this.jaxxContextEntryDef = jaxxContextEntryDef;
            this.jaxxContextEntryPath = jaxxContextEntryPath;
        }

        public String getNavigationPath() {
            return this.navigationPath;
        }

        public void setNavigationPath(String navigationPath) {
            this.navigationPath = navigationPath;
        }

        public Class<? extends JAXXObject> getJaxxClass() {
            return this.jaxxClass;
        }

        public void setJaxxClass(Class<? extends JAXXObject> jaxxClass) {
            this.jaxxClass = jaxxClass;
        }

        public void setInternalClass(Class<?> internalClass) {
            this.internalClass = internalClass;
        }

        public Class<? extends JAXXAction> getJaxxActionClass() {
            return this.jaxxActionClass;
        }

        public void setJaxxActionClass(Class<? extends JAXXAction> jaxxActionClass) {
            this.jaxxActionClass = jaxxActionClass;
        }

        public JAXXContextEntryDef<?> getJaxxContextEntryDef() {
            return this.jaxxContextEntryDef;
        }

        public void setJaxxContextEntryDef(JAXXContextEntryDef<?> jaxxContextEntryDef) {
            this.jaxxContextEntryDef = jaxxContextEntryDef;
        }

        public String getJaxxContextEntryPath() {
            return this.jaxxContextEntryPath;
        }

        public void setJaxxContextEntryPath(String jaxxContextEntryPath) {
            this.jaxxContextEntryPath = jaxxContextEntryPath;
        }

        public Class<?> getInternalClass() {
            return this.internalClass == null ? this.renderer.getInternalClass() : this.internalClass;
        }

        public String getContextPath() {
            if (this.cachedNavigationPath == null) {
                TreeNode[] path = this.getPath();
                StringBuilder sb = new StringBuilder();
                for (TreeNode treeNode : path) {
                    NavigationTreeNode myNode = (NavigationTreeNode)treeNode;
                    sb.append(NavigationTreeModel.this.navigationPathSeparator).append(myNode.getNavigationPath());
                }
                this.cachedNavigationPath = sb.substring(1);
            }
            return this.cachedNavigationPath;
        }

        @Override
        public NavigationTreeNode getChildAt(int index) {
            return (NavigationTreeNode)super.getChildAt(index);
        }

        @Override
        public NavigationTreeNode getParent() {
            return (NavigationTreeNode)super.getParent();
        }

        public NavigationTreeNode getChild(String navigationPath) {
            int max = this.getChildCount();
            for (int i = 0; i < max; ++i) {
                NavigationTreeNode son = this.getChildAt(i);
                if (!navigationPath.equals(son.getNavigationPath())) continue;
                return son;
            }
            return null;
        }

        public Object getJAXXContextValue(JAXXContext context) {
            if (this.cachedBean != null) {
                return this.cachedBean;
            }
            if (this.getJaxxContextEntryDef() != null && this.jaxxContextEntryPath == null) {
                Object result = this.getJaxxContextEntryDef().getContextValue(context);
                this.setCachedBean(result);
                return result;
            }
            NavigationTreeNode parentNode = this.getFirstAncestorWithDef();
            if (parentNode == null) {
                log.warn((Object)("could not find a ancestor node with a definition of a context entry from node (" + this + ")"));
                return null;
            }
            Object parentBean = parentNode.getJaxxContextEntryDef().getContextValue(context);
            if (parentBean == null) {
                log.warn((Object)("culd not find a bean attached in context from context entry definition " + parentNode.getJaxxContextEntryDef()));
                return null;
            }
            if (parentNode.jaxxContextEntryPath != null) {
                JXPathContext jxcontext = JXPathContext.newContext((Object)parentBean);
                parentBean = jxcontext.getValue(parentNode.jaxxContextEntryPath);
            }
            parentNode.setCachedBean(parentBean);
            if (this == parentNode) {
                return parentBean;
            }
            if (this.jaxxContextEntryPath == null) {
                log.warn((Object)("must find a jaxxContextEntryPath on node (" + this + ")"));
                return null;
            }
            String jxpathExpression = this.computeJXPath(this.jaxxContextEntryPath, parentNode);
            if (jxpathExpression == null) {
                log.warn((Object)("could not build jxpath from node " + parentNode + " to " + this));
                return null;
            }
            if (jxpathExpression.startsWith("[")) {
                jxpathExpression = '.' + jxpathExpression;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("jxpath : " + jxpathExpression));
            }
            JXPathContext jxcontext = JXPathContext.newContext((Object)parentBean);
            Object result = jxcontext.getValue(jxpathExpression);
            this.setCachedBean(result);
            return result;
        }

        protected NavigationTreeNode getFirstAncestorWithDef() {
            if (this.jaxxContextEntryDef != null) {
                return this;
            }
            return this.getParent() == null ? null : this.getParent().getFirstAncestorWithDef();
        }

        protected String computeJXPath(String expr, NavigationTreeNode parentNode) {
            if (parentNode == this) {
                return expr;
            }
            int firstIndex = expr.indexOf("..");
            int lastIndex = expr.lastIndexOf("..");
            if (firstIndex == -1) {
                throw new IllegalArgumentException(expr + " should contains at least one \"..\"");
            }
            if (firstIndex != 0) {
                throw new IllegalArgumentException("\"..\" must be at the beginning but was : " + expr);
            }
            NavigationTreeNode ancestor = this.getParent();
            if (firstIndex == lastIndex) {
                String newExpr = expr.substring(2);
                if (this.getParent().equals(parentNode)) {
                    return newExpr;
                }
                if (ancestor.jaxxContextEntryPath == null) {
                    throw new IllegalArgumentException("with the expression " + expr + ", the ancestor node (" + ancestor + ") must have a jaxxContextEntryPath definition, but was not ");
                }
                newExpr = ancestor.jaxxContextEntryPath + newExpr;
                return ancestor.computeJXPath(newExpr, parentNode);
            }
            if (ancestor.jaxxContextEntryPath != null) {
                throw new IllegalArgumentException("with the expression " + expr + ", the ancestor node can not have a jaxxContextEntryPath definition");
            }
            String newExpr = expr.substring(0, lastIndex - 1) + expr.substring(lastIndex + (expr.charAt(lastIndex + 3) == '/' ? 3 : 2));
            return ancestor.computeJXPath(newExpr, parentNode);
        }

        public void clearCache() {
            this.clearCache(false);
        }

        public void clearCache(boolean deep) {
            this.cachedBean = null;
            this.cachedNavigationPath = null;
            if (this.renderer != null) {
                this.renderer.setRendererCachedValue(null);
            }
            if (deep) {
                Enumeration<TreeNode> childs = this.children();
                while (childs.hasMoreElements()) {
                    NavigationTreeNode o = (NavigationTreeNode)childs.nextElement();
                    o.clearCache();
                }
            }
        }

        public Object getCachedBean() {
            return this.cachedBean;
        }

        public void setCachedBean(Object cachedBean) {
            this.cachedBean = cachedBean;
        }
    }
}

