/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.reflect;

import java.util.Arrays;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.reflect.MemberDescriptor;

public class MethodDescriptor
extends MemberDescriptor {
    private final String returnType;
    private final String[] parameterTypes;

    public MethodDescriptor(String name, int modifiers, String returnType, String[] parameterTypes, ClassLoader classLoader) {
        super(name, modifiers, classLoader);
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        if (JAXXCompiler.STRICT_CHECKS && Arrays.asList(parameterTypes).contains(null)) {
            throw new NullPointerException(name);
        }
    }

    public ClassDescriptor getReturnType() {
        try {
            if (this.returnType == null) {
                return null;
            }
            return ClassDescriptorHelper.getClassDescriptor(this.returnType);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("could not find return type " + this.returnType, e);
        }
    }

    public ClassDescriptor[] getParameterTypes() {
        ClassDescriptor[] result = new ClassDescriptor[this.parameterTypes.length];
        try {
            for (int i = 0; i < result.length; ++i) {
                if (this.parameterTypes[i] == null) continue;
                result[i] = ClassDescriptorHelper.getClassDescriptor(this.parameterTypes[i], this.getClassLoader());
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("could not find the parameter types " + Arrays.toString(this.parameterTypes), e);
        }
    }
}

