/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler;

import java.util.Map;
import java.util.TreeMap;
import jaxx.CompilerException;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JavaFile;

public abstract class CompiledObjectDecorator {
    protected static Map<String, CompiledObjectDecorator> cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDecorator(String key, Class<? extends CompiledObjectDecorator> klass) {
        Map<String, CompiledObjectDecorator> map = CompiledObjectDecorator.getCache();
        synchronized (map) {
            if (CompiledObjectDecorator.getCache().containsKey(key)) {
                throw new IllegalArgumentException("the decorator with key [" + key + "] is already registred! use another key name");
            }
            try {
                CompiledObjectDecorator.getCache().put(key, klass.newInstance());
            }
            catch (InstantiationException ex) {
                throw new IllegalArgumentException("could not create decorator " + klass + " for reason " + ex.getMessage(), ex);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException("could not create decorator " + klass + " for reason " + ex.getMessage(), ex);
            }
        }
    }

    public static CompiledObjectDecorator getDecorator(String name) {
        CompiledObjectDecorator decorator = CompiledObjectDecorator.getCache().get(name);
        if (decorator == null) {
            throw new IllegalArgumentException("could not find decorator with key " + name + " (known decorators : " + CompiledObjectDecorator.getCache().keySet());
        }
        return decorator;
    }

    public static CompiledObjectDecorator getDecorator(Class<?> type) {
        for (CompiledObjectDecorator decorator : CompiledObjectDecorator.getCache().values()) {
            if (type != decorator.getClass()) continue;
            return decorator;
        }
        return null;
    }

    protected static synchronized Map<String, CompiledObjectDecorator> getCache() {
        if (cache == null) {
            cache = new TreeMap<String, CompiledObjectDecorator>();
        }
        return cache;
    }

    public static void reset() {
        if (cache != null) {
            cache.clear();
        }
    }

    public abstract void finalizeCompiler(JAXXCompiler var1, CompiledObject var2, CompiledObject var3, JavaFile var4, String var5, String var6, String var7);

    public abstract String getCreationCode(JAXXCompiler var1, CompiledObject var2) throws CompilerException;

    public abstract boolean createInitializer(JAXXCompiler var1, CompiledObject var2, CompiledObject var3, StringBuffer var4, boolean var5);

    public abstract String createCompleteSetupMethod(JAXXCompiler var1, CompiledObject var2, JavaFile var3, StringBuffer var4);
}

