/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.types;

import jaxx.types.*;
import javax.swing.KeyStroke;

public class KeyStrokeConverter implements TypeConverter {
    public String getJavaCode(Object object) {
        return "KeyStroke.getKeyStroke(\"" + object.toString() + "\")";
    }


    public Object convertFromString(String string, Class type) {
        if (type != KeyStroke.class) {
            throw new IllegalArgumentException("unsupported type: " + type);
        }
        return KeyStroke.getKeyStroke(string);
    }
}