/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.compiler;

import jaxx.reflect.ClassDescriptorLoader;
import jaxx.tags.DefaultObjectHandler;

import java.io.File;

/**
 * Swing JAXX compiler.
 * <p/>
 * todo finish javadoc
 */
public class SwingCompiler extends JAXXCompiler {

    /*---------------------------------------------------------------------------------*/
    /*-- Constructor methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public SwingCompiler(ClassLoader classLoader) {
        super(classLoader,
                new DefaultObjectHandler(ClassDescriptorLoader.getClassDescriptor(Object.class)),
                "java.awt.*",
                "java.awt.event.*",
                "java.beans.*",
                "java.io.*",
                "java.lang.*",
                "java.util.*",
                "javax.swing.*",
                "javax.swing.border.*",
                "javax.swing.event.*",
                "jaxx.runtime.swing.JAXXButtonGroup",
                "jaxx.runtime.swing.HBox",
                "jaxx.runtime.swing.VBox",
                "jaxx.runtime.swing.Table",
                "static org.nuiton.i18n.I18n._",
                "static jaxx.runtime.Util.createImageIcon");


    }

    /**
     * Creates a new SwingCompiler.
     *
     * @param baseDir         classpath location
     * @param options         options to pass to javac
     * @param src             location of file to compile
     * @param outputClassName the out file name
     */
    public SwingCompiler(File baseDir, File src, String outputClassName, CompilerOptions options) {
        super(baseDir, src, outputClassName, options,
                new DefaultObjectHandler(ClassDescriptorLoader.getClassDescriptor(Object.class)),
                "java.awt.*",
                "java.awt.event.*",
                "java.beans.*",
                "java.io.*",
                "java.lang.*",
                "java.util.*",
                "javax.swing.*",
                "javax.swing.border.*",
                "javax.swing.event.*",
                "jaxx.runtime.swing.JAXXButtonGroup",
                "jaxx.runtime.swing.HBox",
                "jaxx.runtime.swing.VBox",
                "jaxx.runtime.swing.Table",
                "static org.nuiton.i18n.I18n._",
                "static jaxx.runtime.Util.createImageIcon");
    }

}