package org.nuiton.jaxx.application.swing.actionng;

/*
 * #%L
 * JAXX :: Application Swing
 * %%
 * Copyright (C) 2008 - 2014 Code Lutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import javax.swing.event.EventListenerList;

/**
 * Engine what consumes incoming actions.
 *
 * Created on 11/23/13.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 2.8
 */
public class ApplicationActionEngine {

    private final EventListenerList eventList;

    public ApplicationActionEngine() {
        eventList = new EventListenerList();
    }

    public void addAction(ApplicationAction action) {

    }

    //------------------------------------------------------------------------//
    //--- ApplicationActionListener API                                    ---//
    //------------------------------------------------------------------------//

    public void addApplicationEventListener(ApplicationActionListener listener) {
        eventList.add(ApplicationActionListener.class, listener);
    }

    public void removeApplicationEventListener(ApplicationActionListener listener) {
        eventList.remove(ApplicationActionListener.class, listener);
    }

    protected void fireInit(ApplicationAction action) {
        ApplicationActionEvent event = new ApplicationActionEvent(action, ApplicationActionEvent.EventType.INIT);

        ApplicationActionListener[] listeners = eventList.getListeners(ApplicationActionListener.class);
        for (ApplicationActionListener listener : listeners) {
            listener.actionStarted(event);
        }
    }

    protected void fireStart(ApplicationAction action) {
        ApplicationActionEvent event = new ApplicationActionEvent(action, ApplicationActionEvent.EventType.START);

        ApplicationActionListener[] listeners = eventList.getListeners(ApplicationActionListener.class);
        for (ApplicationActionListener listener : listeners) {
            listener.actionStarted(event);
        }
    }

    protected void fireDone(ApplicationAction action) {
        ApplicationActionEvent event = new ApplicationActionEvent(action, ApplicationActionEvent.EventType.DONE);
        ApplicationActionListener[] listeners = eventList.getListeners(ApplicationActionListener.class);
        for (ApplicationActionListener listener : listeners) {
            listener.actionDone(event);
        }
    }

    protected void fireFail(ApplicationAction action, Exception error) {
        ApplicationActionEvent event = new ApplicationActionEvent(action, ApplicationActionEvent.EventType.FAIL);
        event.setError(error);
        ApplicationActionListener[] listeners = eventList.getListeners(ApplicationActionListener.class);
        for (ApplicationActionListener listener : listeners) {
            listener.actionFailed(event);
        }
    }

    protected void fireProgressionChange(ApplicationAction action) {
        ApplicationActionEvent event = new ApplicationActionEvent(action, ApplicationActionEvent.EventType.PROGRESSION_CHANGE);
        ApplicationActionListener[] listeners = eventList.getListeners(ApplicationActionListener.class);
        for (ApplicationActionListener listener : listeners) {
            listener.actionProgressionChanged(event);
        }
    }
}
