package org.nuiton.jaxx.application.bean;

/*
 * #%L
 * JAXX :: Application API
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.apache.commons.lang3.tuple.Pair;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.util.concurrent.ExecutionException;

/**
 * To cache binders.
 *
 * Created on 8/12/14.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 2.10
 */
public class BinderCache {

    public static final LoadingCache<Pair<Class<?>, Class<?>>, Binder> cache = CacheBuilder.newBuilder().build(new CacheLoader<Pair<Class<?>, Class<?>>, Binder>() {
        @Override
        public Binder load(Pair<Class<?>, Class<?>> key) throws Exception {
            return BinderFactory.newBinder(key.getLeft(), key.getRight());
        }
    });

    public static <S, T> Binder<S, T> getBinder(Class<S> sourceType, Class<T> targetType) {
        Pair of = Pair.of(sourceType, targetType);
        try {
            return cache.get(of);
        } catch (ExecutionException e) {
            throw new ApplicationTechnicalException("Could not get binder from cache", e);
        }
    }
}
