/**
 * *##% guix-compiler-swing
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.nuiton.guix.tags.swing;

import org.nuiton.guix.model.AttributeDescriptor;
import org.nuiton.guix.model.GuixModelObject;

/**
 * Represents a cell of a table
 *
 * @author kevin
 */
public class CellHandler extends TableHandler {

    /** id of the object contained by the cell */
    private String id = null;
    /** number of columns of the cell */
    private int columns = 1;
    /** number of rows of the cell */
    private int rows = 1;
    /** index of the row */
    private int row = -1;
    /** index of the column */
    private int column = -1;

    /**
     * Constructor
     */
    public CellHandler() {
        super();
    }

    /**
     * Constructor
     *
     * @param cell the GuixModelObject which represents the cell
     */
    public CellHandler(GuixModelObject cell) {
        assert cell.getChildren().size() == 1;
        id = cell.getChildren().get(0).getId();
        for (AttributeDescriptor attr : cell.getAttributeDescriptors()) {
            if (attr.getName().equals("columns")) {
                columns = Integer.valueOf(attr.getValue());
            }
            else if (attr.getName().equals("column")) {
                column = Integer.valueOf(attr.getValue());
            }
            else if (attr.getName().equals("rows")) {
                rows = Integer.valueOf(attr.getValue());
            }
            else if (attr.getName().equals("weightx")) {
                weightx = Double.valueOf(attr.getValue());
            }
            else if (attr.getName().equals("weighty")) {
                weighty = Double.valueOf(attr.getValue());
            }
            else if (attr.getName().equals("ipadx")) {
                ipadx = Integer.valueOf(attr.getValue());
            }
            else if (attr.getName().equals("ipady")) {
                ipady = Integer.valueOf(attr.getValue());
            }
            else if (attr.getName().equals("horizontalAlignment")) {
                horizontalAlignment = getHalign(attr.getValue());
            }
            else if (attr.getName().equals("verticalAlignment")) {
                verticalAlignment = getValign(attr.getValue());
            }
            else if (attr.getName().equals("fill")) {
                fill = attr.getValue();
            }
            else if (attr.getName().equals("insets")) {
                insets = attr.getValue();
            }
        }
    }

    /**
     * Constructor
     *
     * @param cell the GuixModelObject which represents the cell
     * @param row the row which contains the cell
     */
    public CellHandler(GuixModelObject cell, RowHandler row) {
        this(cell);
        //if the attributes that the row contains too have not been defined by the user within the cell,
        //but have been defined in the row (or the table), set them
        if (horizontalAlignment == null) {
            horizontalAlignment = row.getHorizontalAlignment() == null ? TableHandler.DEFAULT_HORIZONTAL_ALIGNMENT : row.getHorizontalAlignment();
        }
        if (verticalAlignment == null) {
            verticalAlignment = row.getVerticalAlignment() == null ? TableHandler.DEFAULT_VERTICAL_ALIGNMENT : row.getVerticalAlignment();
        }
        if (fill == null) {
            fill = row.getFill() == null ? TableHandler.DEFAULT_FILL : row.getFill();
        }
        if (insets == null) {
            insets = row.getInsets() == null ? TableHandler.DEFAULT_INSETS : row.getInsets();
        }
        if (ipadx == null) {
            ipadx = row.getIpadx() == null ? TableHandler.DEFAULT_IPADX : row.getIpadx();
        }
        if (ipady == null) {
            ipady = row.getIpady() == null ? TableHandler.DEFAULT_IPADY : row.getIpady();
        }
        if (weightx == null) {
            weightx = row.getWeightx() == null ? TableHandler.DEFAULT_WEIGHTX : row.getWeightx();
        }
        if (weighty == null) {
            weighty = row.getWeighty() == null ? TableHandler.DEFAULT_WEIGHTY : row.getWeighty();
        }
        if(this.row == -1) {
            this.row = row.getRow() < 0 ? -1 : row.getRow();
        }
    }

    @Override
    public Class getClassToGenerate() {
        return null;
    }


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getColumn() {
        return column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public int getColumns() {
        return columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public int getRow() {
        return row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public int getRows() {
        return rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }
}
