/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.guix.tags.gwt;

import com.google.gwt.user.client.ui.FlexTable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.guix.model.AttributeDescriptor;
import org.nuiton.guix.model.GuixModelObject;
import org.nuiton.guix.tags.gwt.CellHandler;
import org.nuiton.guix.tags.gwt.UIObjectHandler;

public class TableHandler
extends UIObjectHandler {
    private static Log log = LogFactory.getLog(TableHandler.class);
    public static final String DEFAULT_INSETS = "3, 3, 3, 3";
    public static final HorizontalAlignment DEFAULT_HORIZONTAL_ALIGNMENT = HorizontalAlignment.ALIGN_DEFAULT;
    public static final VerticalAlignment DEFAULT_VERTICAL_ALIGNMENT = VerticalAlignment.ALIGN_TOP;
    public static final String DEFAULT_FILL = "both";
    public static final Integer DEFAULT_IPADX = 1;
    public static final Integer DEFAULT_IPADY = 1;
    public static final Double DEFAULT_WEIGHTX = 0.0;
    public static final Double DEFAULT_WEIGHTY = 0.0;
    protected Double weightx = null;
    protected Double weighty = null;
    protected Integer ipadx = null;
    protected Integer ipady = null;
    protected HorizontalAlignment horizontalAlignment = null;
    protected VerticalAlignment verticalAlignment = null;
    protected String fill = null;
    protected String insets = null;

    public TableHandler() {
    }

    public TableHandler(GuixModelObject table) {
        for (AttributeDescriptor attr : table.getAttributeDescriptors()) {
            if (attr.getName().equalsIgnoreCase("weightx")) {
                this.weightx = Double.valueOf(attr.getValue());
                continue;
            }
            if (attr.getName().equalsIgnoreCase("weighty")) {
                this.weighty = Double.valueOf(attr.getValue());
                continue;
            }
            if (attr.getName().equalsIgnoreCase("ipadx")) {
                this.ipadx = Integer.valueOf(attr.getValue());
                continue;
            }
            if (attr.getName().equalsIgnoreCase("ipady")) {
                this.ipady = Integer.valueOf(attr.getValue());
                continue;
            }
            if (attr.getName().equalsIgnoreCase("horizontalAlignment")) {
                this.horizontalAlignment = this.getHalign(attr.getValue());
                if (this.horizontalAlignment != null) continue;
                if (log.isErrorEnabled()) {
                    log.error((Object)(table.getId() + "'s horizontalAlignment attribute has a wrong value : " + attr.getValue()));
                }
                this.horizontalAlignment = HorizontalAlignment.ALIGN_DEFAULT;
                continue;
            }
            if (attr.getName().equalsIgnoreCase("verticalAlignment")) {
                this.verticalAlignment = this.getValign(attr.getValue());
                if (this.verticalAlignment != null) continue;
                if (log.isErrorEnabled()) {
                    log.error((Object)(table.getId() + "'s verticalAlignment attribute has a wrong value : " + attr.getValue()));
                }
                this.verticalAlignment = VerticalAlignment.ALIGN_TOP;
                continue;
            }
            if (attr.getName().equalsIgnoreCase("fill")) {
                this.fill = attr.getValue();
                continue;
            }
            if (!attr.getName().equalsIgnoreCase("insets")) continue;
            this.insets = attr.getValue();
        }
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public String getFill() {
        return this.fill;
    }

    public void setFill(String fill) {
        this.fill = fill;
    }

    public String getInsets() {
        return this.insets;
    }

    public void setInsets(String insets) {
        this.insets = insets;
    }

    public Integer getIpadx() {
        return this.ipadx;
    }

    public void setIpadx(Integer ipadx) {
        this.ipadx = ipadx;
    }

    public Integer getIpady() {
        return this.ipady;
    }

    public void setIpady(Integer ipady) {
        this.ipady = ipady;
    }

    public Double getWeightx() {
        return this.weightx;
    }

    public void setWeightx(Double weightx) {
        this.weightx = weightx;
    }

    public Double getWeighty() {
        return this.weighty;
    }

    public void setWeighty(Double weighty) {
        this.weighty = weighty;
    }

    public HorizontalAlignment getHalign(String halign) {
        if (halign.equalsIgnoreCase("left")) {
            return HorizontalAlignment.ALIGN_LEFT;
        }
        if (halign.equalsIgnoreCase("right")) {
            return HorizontalAlignment.ALIGN_RIGHT;
        }
        if (halign.equalsIgnoreCase("center")) {
            return HorizontalAlignment.ALIGN_CENTER;
        }
        return null;
    }

    public VerticalAlignment getValign(String valign) {
        if (valign.equalsIgnoreCase("top")) {
            return VerticalAlignment.ALIGN_TOP;
        }
        if (valign.equalsIgnoreCase("bottom")) {
            return VerticalAlignment.ALIGN_BOTTOM;
        }
        if (valign.equalsIgnoreCase("middle")) {
            return VerticalAlignment.ALIGN_MIDDLE;
        }
        return null;
    }

    public static String createCell(String parentId, CellHandler cl, List<List<int[]>> layout, int iC, int r) {
        StringBuffer result = new StringBuffer();
        boolean columnSetByUser = true;
        boolean rowSetByUser = true;
        if (cl.getColumn() == -1) {
            cl.setColumn(iC);
            columnSetByUser = false;
        } else if (cl.getColumn() < iC && log.isErrorEnabled()) {
            log.error((Object)"Error cell column number");
        }
        if (cl.getRow() == -1) {
            cl.setRow(r);
            rowSetByUser = false;
        } else if (rowSetByUser && cl.getRow() < r && log.isErrorEnabled()) {
            log.error((Object)"Error cell row number");
        }
        if (columnSetByUser) {
            iC = cl.getColumn();
        }
        if (r >= layout.size()) {
            for (int i = layout.size(); i <= r; ++i) {
                layout.add(new ArrayList());
            }
        }
        boolean enoughPlace = false;
        while (!enoughPlace) {
            enoughPlace = true;
            while (layout.get(r).size() > iC && layout.get(r).get(iC) != null) {
                if (columnSetByUser && cl.getColumn() == iC && log.isErrorEnabled()) {
                    log.error((Object)"This column is already occupied.");
                }
                iC += layout.get(r).get(iC)[1];
            }
            if (layout.get(r).size() <= iC) continue;
            boolean j = false;
            enoughPlace = layout.get(r).get(iC)[1] < cl.getColumns();
            if (enoughPlace) continue;
            iC += layout.get(r).get(iC)[1];
        }
        cl.setColumn(iC);
        layout.get(r).add(new int[]{cl.getRows(), cl.getColumns()});
        result.append(parentId).append(".setWidget(").append(cl.getRow()).append(",").append(cl.getColumn()).append(",").append(cl.getId()).append(");\n");
        if (cl.getRows() > 1) {
            result.append(parentId).append(".getFlexCellFormatter().setRowSpan(").append(cl.getRow()).append(",").append(cl.getColumn()).append(",").append(cl.getRows()).append(");\n");
        }
        if (cl.getColumns() > 1) {
            result.append(parentId).append(".getFlexCellFormatter().setColSpan(").append(cl.getRow()).append(",").append(cl.getColumn()).append(",").append(cl.getColumns()).append(");\n");
        }
        result.append(parentId).append(".getFlexCellFormatter().setHorizontalAlignment(").append(cl.getRow()).append(",").append(cl.getColumn()).append(",").append("com.google.gwt.user.client.ui.HasHorizontalAlignment.").append((Object)cl.getHorizontalAlignment()).append(");\n");
        result.append(parentId).append(".getFlexCellFormatter().setVerticalAlignment(").append(cl.getRow()).append(",").append(cl.getColumn()).append(",").append("com.google.gwt.user.client.ui.HasVerticalAlignment.").append((Object)cl.getVerticalAlignment()).append(");\n");
        result.append(parentId).append(".getFlexCellFormatter().addStyleName(").append(cl.getRow()).append(",").append(cl.getColumn()).append(", \"Cell\");\n");
        return result.toString();
    }

    public Class getClassToGenerate() {
        return FlexTable.class;
    }

    protected static enum HorizontalAlignment {
        ALIGN_LEFT,
        ALIGN_CENTER,
        ALIGN_RIGHT,
        ALIGN_DEFAULT;

    }

    protected static enum VerticalAlignment {
        ALIGN_TOP,
        ALIGN_MIDDLE,
        ALIGN_BOTTOM;

    }
}

