/**
 * *##% guix-compiler-gwt
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.nuiton.guix.tags.gwt;

import com.google.gwt.event.dom.client.ClickHandler;

/**
 * Handles the ToggleButton tags
 *
 * @author kmorin
 */
public class ToggleButtonHandler extends ButtonHandler {

    public ToggleButtonHandler() {
        super();
        attrMap.put("selected", "down");
    }

    @Override
    public Class getClassToGenerate() {
        return com.google.gwt.user.client.ui.ToggleButton.class;
    }

    @Override
    public void configureProxyEventInfo() {
        super.configureProxyEventInfo();
        addProxyEventInfo("isDown", ClickHandler.class);
    }
}
